/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.mage;

import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class MageExplosionSpell
extends Ability {
    public MageExplosionSpell() {
        super("Mage", "explosion_spell");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onMageAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        XMaterial xMaterial;
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        ConfigurationSection configurationSection = this.getExtra(skilledPlayer, "hoe-chance").getSection();
        String string = configurationSection.getString((xMaterial = XMaterial.matchXMaterial(player.getInventory().getItemInMainHand())).name());
        if (string == null) {
            return;
        }
        int n = (int)this.getAbsoluteScaling(skilledPlayer, string, "damage", entityDamageByEntityEvent.getDamage());
        if (MathUtils.hasChance(n)) {
            Entity entity = entityDamageByEntityEvent.getEntity();
            int n2 = skilledPlayer.getImprovementLevel(this);
            double d = this.getScaling(skilledPlayer, entityDamageByEntityEvent);
            if (n2 > 2 && entityDamageByEntityEvent.getEntity() instanceof Player && MathUtils.hasChance(1, 500)) {
                MessageHandler.sendPlayerMessage(player, "&4\uff23rimson-&0black &6blaze&5, king of myriad worlds, though I promulgate the laws of nature, I am the alias of destruction incarnate in accordance with the principles of all creation.");
                MessageHandler.sendPlayerMessage((Player)entity, "&cYou've been struck by an unexpected crismon detonation power.");
                entity.setMetadata("UNEXP-BIO", (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
                entityDamageByEntityEvent.setDamage(d * d);
                Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
                    if (!entityDamageByEntityEvent.getEntity().isDead()) {
                        entityDamageByEntityEvent.getEntity().removeMetadata("UNEXP-BIO", (Plugin)SkillsPro.get());
                    }
                }, 1L);
                XSound.ENTITY_GENERIC_EXPLODE.play(entity);
                if (XMaterial.supports(12)) {
                    XSound.UI_TOAST_CHALLENGE_COMPLETE.play(entity);
                }
                XParticle.meguminExplosion(SkillsPro.get(), 3.0, ParticleDisplay.simple(entity.getLocation(), Particle.FLAME));
                player.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, entity.getLocation(), n2 * 3, 1.0, 1.0, 1.0);
                return;
            }
            player.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, entity.getLocation(), n2 * 2, 1.0, 1.0, 1.0);
            XSound.ENTITY_FIREWORK_ROCKET_LARGE_BLAST.play(entity);
            entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        if (playerDeathEvent.getEntity().hasMetadata("UNEXP-BIO")) {
            playerDeathEvent.setDeathMessage("&6" + playerDeathEvent.getEntity().getName() + " &4has been struck by &6" + playerDeathEvent.getEntity().getKiller().getName() + "'s &4unexpected crismon detonation power.");
            playerDeathEvent.getEntity().removeMetadata("UNEXP-BIO", (Plugin)SkillsPro.get());
        }
    }
}

