/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.mage;

import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.managers.LastHitManager;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;

public class MageEnergyFlux
extends ActiveAbility {
    public MageEnergyFlux() {
        super("Mage", "energy_flux", true);
    }

    private static Color getColor(double d) {
        if (d < 3.0) {
            return Color.BLACK;
        }
        if (d < 6.0) {
            return Color.SILVER;
        }
        if (d < 10.0) {
            return Color.GRAY;
        }
        if (d < 15.0) {
            return Color.WHITE;
        }
        if (d < 20.0) {
            return Color.BLUE;
        }
        if (d < 25.0) {
            return Color.NAVY;
        }
        if (d < 30.0) {
            return Color.LIME;
        }
        if (d < 35.0) {
            return Color.GREEN;
        }
        if (d < 40.0) {
            return Color.AQUA;
        }
        if (d < 45.0) {
            return Color.TEAL;
        }
        if (d < 50.0) {
            return Color.YELLOW;
        }
        if (d < 60.0) {
            return Color.ORANGE;
        }
        if (d < 70.0) {
            return Color.PURPLE;
        }
        if (d < 100.0) {
            return Color.MAROON;
        }
        return Color.RED;
    }

    @Override
    public void useSkill(Player player) {
        SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        Location location = player.getEyeLocation();
        Location location2 = location.clone().add(location.getDirection().multiply(this.getExtraScaling(skilledPlayer, "range", new Object[0])));
        this.fireEnergyFlux(player, skilledPlayer, location, location2);
        XSound.ENTITY_FIREWORK_ROCKET_TWINKLE.play((Entity)player);
    }

    private void fireEnergyFlux(Player player, SkilledPlayer skilledPlayer, Location location, Location location2) {
        double d = this.getScaling(skilledPlayer, new Object[0]);
        int n = skilledPlayer.getImprovementLevel(this);
        double d2 = (double)n * 0.5;
        Color color = MageEnergyFlux.getColor(skilledPlayer.getLevel());
        HashSet<UUID> hashSet = new HashSet<UUID>();
        hashSet.add(player.getUniqueId());
        Vector vector = location2.toVector().subtract(location.toVector());
        double d3 = vector.length();
        vector.normalize();
        double d4 = vector.getX();
        double d5 = vector.getY();
        double d6 = vector.getZ();
        boolean bl = XMaterial.isNewVersion();
        boolean bl2 = !this.getExtra(skilledPlayer, "pass-through").getBoolean();
        World world = player.getLocation().getWorld();
        for (double d7 = 0.5; d7 < d3; d7 += 0.1) {
            Location location3 = location.clone().add(d4 * d7, d5 * d7, d6 * d7);
            VersionSupport.spawnColouredDust(location3, color);
            if ((bl2 || n < 3) && (bl ? !location3.getBlock().isPassable() : !location3.getBlock().getType().name().endsWith("AIR"))) break;
            for (Entity entity : world.getNearbyEntities(location3, d2, d2, d2)) {
                if (!(entity instanceof LivingEntity) || !entity.isValid() || !hashSet.add(entity.getUniqueId())) continue;
                LastHitManager.damage((LivingEntity)entity, player, d);
            }
        }
    }
}

