/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.juggernaut;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.LastHitManager;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XSound;
import org.spigotmc.event.entity.EntityDismountEvent;

public class JuggernautThrow
extends ActiveAbility {
    private static final Map<Integer, Integer> activeCarryCount = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> throwPairs = new HashMap<Integer, Integer>();

    public JuggernautThrow() {
        super("Juggernaut", "throw", false);
    }

    @EventHandler(ignoreCancelled=true)
    public void onJuggernautAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        boolean bl = false;
        for (String string : this.getExtra(skilledPlayer, "whitelist").getStringList()) {
            if (string.equals("*")) {
                bl = true;
                break;
            }
            Optional optional = Enums.getIfPresent(EntityType.class, (String)string.toUpperCase(Locale.ENGLISH));
            if (!optional.isPresent() || optional.get() != entityDamageByEntityEvent.getEntity().getType()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.useSkill(player);
        this.carryEntity(player, skilledPlayer, (LivingEntity)entityDamageByEntityEvent.getEntity());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityAttemptDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (throwPairs.containsKey(entityDamageByEntityEvent.getEntity().getEntityId())) {
            entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() / 2.0);
        }
        if (throwPairs.containsKey(entityDamageByEntityEvent.getDamager().getEntityId()) || throwPairs.containsValue(entityDamageByEntityEvent.getDamager().getEntityId())) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onThrowExit(EntityDismountEvent entityDismountEvent) {
        if (throwPairs.containsKey(entityDismountEvent.getDismounted().getEntityId())) {
            entityDismountEvent.setCancelled(true);
        }
    }

    private void carryEntity(final Player player, final SkilledPlayer skilledPlayer, final LivingEntity livingEntity) {
        throwPairs.put(player.getEntityId(), livingEntity.getEntityId());
        player.setPassenger((Entity)livingEntity);
        SkillsLang.Skill_Juggernaut_Active_Activated_Message.sendMessage(player, new Object[0]);
        new BukkitRunnable(){

            public void run() {
                int n = activeCarryCount.getOrDefault(livingEntity.getEntityId(), 0);
                if (livingEntity.isValid() && n < 3 && player.isValid()) {
                    activeCarryCount.put(livingEntity.getEntityId(), ++n);
                    if (!VersionSupport.isPassenger((Entity)player, (Entity)livingEntity)) {
                        player.setPassenger((Entity)livingEntity);
                    }
                    SkillsLang.Skill_Juggernaut_Active_Throw_Message_Countdown.sendMessage(player, "%countdown%", 3 - n);
                    player.playNote(player.getLocation(), Instrument.CHIME, Note.natural((int)1, (Note.Tone)Note.Tone.values()[n]));
                } else {
                    throwPairs.remove(player.getEntityId());
                    activeCarryCount.remove(livingEntity.getEntityId());
                    SkillsLang.Skill_Juggernaut_Active_Throw_Success.sendMessage(player, new Object[0]);
                    this.cancel();
                    if (!VersionSupport.isPassenger((Entity)player, (Entity)livingEntity)) {
                        player.setPassenger((Entity)livingEntity);
                    }
                    player.eject();
                    livingEntity.eject();
                    livingEntity.teleport(player.getLocation().add(0.0, 1.0, 0.0));
                    Vector vector = player.getLocation().getDirection().multiply(2);
                    livingEntity.setVelocity(vector);
                    double d = JuggernautThrow.this.getScaling(skilledPlayer, new Object[0]);
                    LastHitManager.damage(livingEntity, player, d);
                    XSound.ENTITY_EGG_THROW.play((Entity)player, 2.0f, 0.0f);
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 20L);
    }
}

