/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.juggernaut;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;

public class JuggernautStoneSkin
extends Ability {
    public JuggernautStoneSkin() {
        super("Juggernaut", "stone_skin");
    }

    @EventHandler(ignoreCancelled=true)
    public void onJuggernautDefend(EntityDamageEvent entityDamageEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageEvent.getEntity().getLocation())) {
            return;
        }
        if (entityDamageEvent.getEntity() instanceof Player) {
            Player player = (Player)entityDamageEvent.getEntity();
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            ConfigurationSection configurationSection = this.getExtra(skilledPlayer, "protections").getSection();
            if (configurationSection == null) {
                return;
            }
            for (String string : configurationSection.getKeys(false)) {
                Optional optional = Enums.getIfPresent(EntityDamageEvent.DamageCause.class, (String)string.toUpperCase(Locale.ENGLISH));
                if (!optional.isPresent() || entityDamageEvent.getCause() != optional.get()) continue;
                entityDamageEvent.setDamage(entityDamageEvent.getDamage() - this.getAbsoluteScaling(skilledPlayer, configurationSection.getString(string), "damage", entityDamageEvent.getDamage()));
                break;
            }
        }
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        ConfigurationSection configurationSection = this.getExtra(skilledPlayer, "protections").getSection();
        if (configurationSection == null) {
            return new Object[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : configurationSection.getKeys(false)) {
            String string2;
            Optional optional = Enums.getIfPresent(EntityDamageEvent.DamageCause.class, (String)string.toUpperCase(Locale.ENGLISH));
            if (!optional.isPresent()) continue;
            String string3 = configurationSection.getString(string);
            try {
                string2 = "" + this.getAbsoluteScaling(skilledPlayer, string3, new Object[0]);
            }
            catch (ArithmeticException arithmeticException) {
                string2 = configurationSection.getString(string);
            }
            arrayList.add("%" + ((EntityDamageEvent.DamageCause)optional.get()).name().toLowerCase(Locale.ENGLISH) + "%");
            arrayList.add(Ability.getScalingColor(string3) + string2);
        }
        return arrayList.toArray();
    }
}

