/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.juggernaut;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.utils.MathUtils;

public class JuggernautPassive
extends Ability {
    public JuggernautPassive() {
        super("Juggernaut", "passive");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onJuggernautDefend(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity() instanceof Player) {
            Player player = (Player)entityDamageByEntityEvent.getEntity();
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            if (MathUtils.hasChance((int)this.getExtraScaling(skilledPlayer, "chance", entityDamageByEntityEvent))) {
                double d = this.getScaling(skilledPlayer, entityDamageByEntityEvent);
                entityDamageByEntityEvent.setDamage(Math.max(0.0, entityDamageByEntityEvent.getDamage() - d));
            }
        }
    }
}

