/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.juggernaut;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.utils.xseries.XMaterial;

public class JuggernautHeavyStrikes
extends Ability {
    public JuggernautHeavyStrikes() {
        super("Juggernaut", "heavy_strikes");
    }

    @EventHandler(ignoreCancelled=true)
    public void onJuggernautAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        ItemStack[] itemStackArray;
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack == null) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        XMaterial xMaterial = XMaterial.matchXMaterial(itemStack);
        if (!xMaterial.isOneOf(this.getExtra(skilledPlayer, "weapons").getStringList())) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        for (ItemStack itemStack2 : itemStackArray = livingEntity.getEquipment().getArmorContents()) {
            if (itemStack2 == null) continue;
            double d = this.getScaling(skilledPlayer, "durability", itemStack2.getDurability());
            itemStack2.setDurability((short)((double)itemStack2.getDurability() + d));
        }
        livingEntity.getEquipment().setArmorContents(itemStackArray);
    }
}

