/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.juggernaut;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.managers.LastHitManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class JuggernautChainSmash
extends ActiveAbility {
    private static final Set<UUID> performing = new HashSet<UUID>();
    private static final String CHAIN_SMASH = "CHAIN_SMASH";

    public JuggernautChainSmash() {
        super("Juggernaut", "chain_smash", true);
    }

    @EventHandler(ignoreCancelled=true)
    public void tntDmaage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof TNTPrimed)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!entity.hasMetadata(CHAIN_SMASH)) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)((UUID)((MetadataValue)entity.getMetadata(CHAIN_SMASH).get(0)).value()));
        if (player != null && player.getUniqueId().equals(entityDamageByEntityEvent.getEntity().getUniqueId())) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFall(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL && entityDamageEvent.getEntity() instanceof Player && performing.remove(entityDamageEvent.getEntity().getUniqueId())) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @Override
    protected void useSkill(final Player player) {
        final SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        player.setVelocity(new Vector(0, 1, 0));
        XSound.ENTITY_HORSE_JUMP.play((Entity)player, 3.0f, 0.0f);
        final ParticleDisplay particleDisplay = new ParticleDisplay(Particle.CLOUD, player.getLocation(), 100, 1.0, 1.0, 1.0);
        particleDisplay.spawn();
        performing.add(player.getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            player.setVelocity(new Vector(0, -3, 0));
            new BukkitRunnable(){

                public void run() {
                    boolean bl = MathUtils.isInteger(player.getLocation().getY());
                    if (player.isFlying() || bl) {
                        this.cancel();
                        particleDisplay.spawn(player.getLocation());
                        TNTPrimed tNTPrimed = (TNTPrimed)player.getLocation().getWorld().spawnEntity(player.getLocation(), EntityType.PRIMED_TNT);
                        tNTPrimed.setMetadata(JuggernautChainSmash.CHAIN_SMASH, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)player.getUniqueId()));
                        tNTPrimed.setFuseTicks(0);
                        double d = JuggernautChainSmash.this.getScaling(skilledPlayer, new Object[0]);
                        double d2 = JuggernautChainSmash.this.getExtraScaling(skilledPlayer, "range", new Object[0]);
                        double d3 = JuggernautChainSmash.this.getExtraScaling(skilledPlayer, "launch", new Object[0]);
                        XSound.ENTITY_GENERIC_EXPLODE.play((Entity)player, (float)d2, 0.0f);
                        ParticleDisplay particleDisplay2 = new ParticleDisplay(Particle.EXPLOSION_LARGE, null, 10, 1.0, 1.0, 1.0);
                        JuggernautChainSmash.this.explosionWave(SkillsPro.get(), 20.0, ParticleDisplay.simple(player.getLocation(), Particle.FIREWORKS_SPARK), ParticleDisplay.simple(player.getLocation(), Particle.SPELL_WITCH));
                        for (Entity entity : player.getNearbyEntities(d2, d2, d2)) {
                            Player player2;
                            if (!(entity instanceof LivingEntity) || !entity.isValid() || entity.getType() == EntityType.ARMOR_STAND || entity instanceof Player && ((player2 = (Player)entity).getGameMode() == GameMode.CREATIVE || player2.getGameMode() == GameMode.SPECTATOR) || !ServiceHandler.canFight(entity, (Entity)player)) continue;
                            LastHitManager.damage((LivingEntity)entity, player, d);
                            entity.setVelocity(new Vector(0.0, d3, 0.0));
                            particleDisplay2.spawn(entity.getLocation());
                        }
                        performing.remove(player.getUniqueId());
                    }
                }
            }.runTaskTimer((Plugin)SkillsPro.get(), 1L, 1L);
        }, 20L);
    }

    private void explosionWave(JavaPlugin javaPlugin, final double d, final ParticleDisplay particleDisplay, final ParticleDisplay particleDisplay2) {
        new BukkitRunnable(){
            final double addition = 0.3141592653589793;
            final double rateDiv = Math.PI / d;
            double times = 0.7853981633974483;

            public void run() {
                this.times += 0.3141592653589793;
                for (double d5 = 0.0; d5 <= Math.PI * 2; d5 += this.rateDiv) {
                    double d2 = this.times * Math.cos(d5);
                    double d3 = 2.0 * Math.exp(-0.1 * this.times) * Math.sin(this.times) + 1.5;
                    double d4 = this.times * Math.sin(d5);
                    particleDisplay.spawn(d2, d3, d4);
                    d2 = this.times * Math.cos(d5 += 0.04908738521234052);
                    d4 = this.times * Math.sin(d5);
                    particleDisplay2.spawn(d2, d3, d4);
                }
                if (this.times > 20.0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)javaPlugin, 0L, 1L);
    }
}

