/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.juggernaut;

import java.util.concurrent.TimeUnit;
import org.bukkit.Particle;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.LastHitManager;
import org.skills.utils.Cooldown;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class JuggernautAegisProtection
extends Ability {
    private static final String AEGIS = "JUGGERNAUT_AEGIS";

    public JuggernautAegisProtection() {
        super("Juggernaut", "aegis_protection");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onJuggernautDefend(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity() instanceof Player && !(entityDamageByEntityEvent.getDamager() instanceof EnderPearl)) {
            Player player = (Player)entityDamageByEntityEvent.getEntity();
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            if (!Cooldown.isInCooldown(player.getUniqueId(), AEGIS)) {
                ParticleDisplay particleDisplay;
                Entity entity;
                long l = (long)this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent.getDamage());
                new Cooldown(player.getUniqueId(), AEGIS, l, TimeUnit.SECONDS);
                entityDamageByEntityEvent.setCancelled(true);
                int n = skilledPlayer.getImprovementLevel(this);
                player.getLocation().getWorld().spawnParticle(Particle.SMOKE_LARGE, player.getLocation(), 30, 1.0, 1.0, 1.0, 0.3);
                XSound.ENTITY_ITEM_BREAK.play((Entity)player);
                if (n > 1) {
                    entity = entityDamageByEntityEvent.getDamager();
                    if (entity instanceof Projectile && (entity = (Entity)((Projectile)entity).getShooter()) == null) {
                        entity = entityDamageByEntityEvent.getDamager();
                    }
                    XSound.ENTITY_GENERIC_EXPLODE.play((Entity)player);
                    particleDisplay = ParticleDisplay.simple(entity.getLocation(), Particle.FLAME);
                    particleDisplay.offset(1.0, 1.0, 1.0);
                    if (entity instanceof LivingEntity) {
                        double d = this.getExtraScaling(skilledPlayer, "damage", entityDamageByEntityEvent);
                        LastHitManager.damage((LivingEntity)entity, player, d);
                    }
                }
                if (n > 2 && (double)VersionSupport.getHealthPercent((LivingEntity)player) < this.getExtraScaling(skilledPlayer, "knockback.health", entityDamageByEntityEvent)) {
                    entity = entityDamageByEntityEvent.getDamager();
                    particleDisplay = entity.getLocation().toVector().subtract(player.getLocation().toVector());
                    entity.setVelocity(particleDisplay.multiply(this.getExtraScaling(skilledPlayer, "knockback.velocity", entityDamageByEntityEvent)));
                }
                SkillsLang.Skill_Juggernaut_Aegis_Success.sendMessage(player, new Object[0]);
            }
        }
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%damage%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer, "damage").getString())};
    }
}

