/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.firemage;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.versionsupport.VersionSupport;

public class FireMagePassive
extends Ability {
    public FireMagePassive() {
        super("FireMage", "passive");
    }

    @EventHandler(ignoreCancelled=true)
    public void onFireMageHeal(EntityRegainHealthEvent entityRegainHealthEvent) {
        if (entityRegainHealthEvent.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityRegainHealthEvent.getEntity().getLocation())) {
            return;
        }
        if (!(entityRegainHealthEvent.getEntity() instanceof Player)) {
            return;
        }
        if (ServiceHandler.isNPC(entityRegainHealthEvent.getEntity())) {
            return;
        }
        Player player = (Player)entityRegainHealthEvent.getEntity();
        if (player.getFireTicks() <= 0) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        entityRegainHealthEvent.setAmount(entityRegainHealthEvent.getAmount() + this.getScaling(skilledPlayer, new Object[0]));
    }

    @EventHandler(ignoreCancelled=true)
    public void onFireDamage(EntityDamageEvent entityDamageEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageEvent.getEntity().getLocation())) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (ServiceHandler.isNPC(entityDamageEvent.getEntity())) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FIRE) {
            entityDamageEvent.setCancelled(true);
        } else if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
            entityDamageEvent.setCancelled(true);
            VersionSupport.heal(player, this.getScaling(skilledPlayer, new Object[0]));
        }
    }
}

