/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.firemage;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.managers.LastHitManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class FireMageMeteorite
extends ActiveAbility {
    private static final String METEORITE = "METEORITE";

    public FireMageMeteorite() {
        super("FireMage", "meteorite", true);
    }

    @Override
    protected void useSkill(Player player) {
        List list;
        Location location;
        Block block;
        final SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (XMaterial.supports(13)) {
            block = player.getTargetBlockExact(20);
        } else {
            location = EnumSet.of(Material.AIR, XMaterial.TALL_GRASS.parseMaterial());
            list = player.getLineOfSight(location, 20);
            block = (Block)list.get(list.size() - 1);
        }
        location = block == null ? player.getLocation().clone().add(player.getLocation().getDirection().multiply(20)) : block.getLocation();
        list = location.clone().add(0.0, 5.0, 0.0);
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        ParticleDisplay particleDisplay = ParticleDisplay.simple(null, Particle.FLAME).withCount(10);
        ParticleDisplay particleDisplay2 = ParticleDisplay.simple(null, Particle.EXPLOSION_NORMAL).withCount(10).offset(1.0, 1.0, 1.0);
        new BukkitRunnable((Location)list, threadLocalRandom, location, player, particleDisplay, particleDisplay2){
            final float yield;
            int balls;
            final /* synthetic */ Location val$source;
            final /* synthetic */ ThreadLocalRandom val$random;
            final /* synthetic */ Location val$loc;
            final /* synthetic */ Player val$player;
            final /* synthetic */ ParticleDisplay val$display;
            final /* synthetic */ ParticleDisplay val$ex;
            {
                this.val$source = location;
                this.val$random = threadLocalRandom;
                this.val$loc = location2;
                this.val$player = player;
                this.val$display = particleDisplay;
                this.val$ex = particleDisplay2;
                this.yield = (float)FireMageMeteorite.this.getExtraScaling(skilledPlayer, "yield", new Object[0]);
                this.balls = (int)FireMageMeteorite.this.getExtraScaling(skilledPlayer, "fireballs", new Object[0]);
            }

            public void run() {
                Location location = this.val$source.clone().add(this.val$random.nextDouble(-3.0, 3.0), this.val$random.nextDouble(1.0, 15.0), this.val$random.nextDouble(-3.0, 3.0));
                Location location2 = this.val$loc.clone().add(this.val$random.nextDouble(-1.0, 1.0), 0.0, this.val$random.nextDouble(-1.0, 1.0));
                Vector vector = location2.toVector().subtract(location.toVector());
                final Fireball fireball = (Fireball)location.getWorld().spawnEntity(location, EntityType.FIREBALL);
                fireball.setDirection(vector.multiply(0.01));
                fireball.setYield(this.yield);
                fireball.setMetadata(FireMageMeteorite.METEORITE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)this.val$player.getUniqueId()));
                new BukkitRunnable(){

                    public void run() {
                        if (!fireball.isValid()) {
                            this.cancel();
                            return;
                        }
                        val$display.spawn(fireball.getLocation());
                        val$ex.spawn(fireball.getLocation());
                    }
                }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
                if (this.balls-- == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, 5L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onFireBall(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Fireball)) {
            return;
        }
        Fireball fireball = (Fireball)entityDamageByEntityEvent.getDamager();
        List list = fireball.getMetadata(METEORITE);
        if (list.isEmpty()) {
            return;
        }
        UUID uUID = (UUID)((MetadataValue)list.get(0)).value();
        if (entityDamageByEntityEvent.getEntity().getUniqueId().equals(uUID)) {
            entityDamageByEntityEvent.setCancelled(true);
        } else {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player == null || !ServiceHandler.canFight(entityDamageByEntityEvent.getEntity(), (Entity)player)) {
                entityDamageByEntityEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onFireballLand(ProjectileHitEvent projectileHitEvent) {
        if (!(projectileHitEvent.getEntity() instanceof Fireball)) {
            return;
        }
        Fireball fireball = (Fireball)projectileHitEvent.getEntity();
        if (!fireball.hasMetadata(METEORITE)) {
            return;
        }
        ParticleDisplay particleDisplay = ParticleDisplay.simple(fireball.getLocation(), Particle.LAVA).withCount(50).offset(1.0, 1.0, 1.0);
        particleDisplay.spawn();
        UUID uUID = (UUID)((MetadataValue)fireball.getMetadata(METEORITE).get(0)).value();
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer(offlinePlayer);
        double d = this.getScaling(skilledPlayer, new Object[0]);
        double d2 = this.getExtraScaling(skilledPlayer, "range", new Object[0]);
        for (Entity entity : fireball.getNearbyEntities(d2, d2, d2)) {
            Player player;
            if (!(entity instanceof LivingEntity) || entity.getType() == EntityType.ARMOR_STAND || entity.getUniqueId().equals(offlinePlayer.getUniqueId()) || entity instanceof Player && ((player = (Player)entity).getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR)) continue;
            LastHitManager.damage((LivingEntity)entity, (Player)offlinePlayer, d);
        }
    }
}

