/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.firemage;

import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.services.manager.ServiceHandler;

public class FireMageBlackFire
extends Ability {
    public FireMageBlackFire() {
        super("FireMage", "black_fire");
    }

    @EventHandler(ignoreCancelled=true)
    public void onFireDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK && entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FIRE) {
            return;
        }
        for (Entity entity : entityDamageEvent.getEntity().getNearbyEntities(5.0, 5.0, 5.0)) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (ServiceHandler.isNPC((Entity)player)) {
                return;
            }
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            double d = this.getScaling(skilledPlayer, new Object[0]);
            entityDamageEvent.setDamage(entityDamageEvent.getDamage() + d);
            player.getWorld().playEffect(entityDamageEvent.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.COAL_BLOCK);
        }
    }
}

