/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.firemage;

import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class FireMageAbsorbEnergy
extends Ability {
    public FireMageAbsorbEnergy() {
        super("FireMage", "absorb_energy");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onFireMageAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        int n = (int)this.getScaling(skilledPlayer, new Object[0]);
        int n2 = skilledPlayer.getImprovementLevel(this);
        if (MathUtils.hasChance(n)) {
            Entity entity = entityDamageByEntityEvent.getEntity();
            entity.setFireTicks((int)((double)entity.getFireTicks() + this.getExtraScaling(skilledPlayer, "fire", entityDamageByEntityEvent) * 20.0));
            if (n2 == 1) {
                player.spawnParticle(Particle.FLAME, entity.getLocation(), n / 2, 0.5, 0.5, 0.5, 0.2);
            } else {
                XSound.ITEM_FIRECHARGE_USE.play(entity);
                if (n2 == 2) {
                    player.spawnParticle(Particle.FLAME, entity.getLocation(), n / 2 + 10, 0.3, 0.3, 0.3, 0.3);
                } else {
                    XParticle.helix(SkillsPro.get(), 3, 0.7, 0.1, 1.0, 5, 1, false, false, ParticleDisplay.simple(entity.getLocation(), Particle.FLAME).withCount(2));
                }
            }
        }
    }
}

