/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.skills.abilities.Ability;
import org.skills.abilities.eidolon.EidolonForm;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.MathUtils;

public class EidolonSpiritFire
extends Ability {
    private static final Map<UUID, Integer> prepped = new HashMap<UUID, Integer>();

    public EidolonSpiritFire() {
        super("Eidolon", "spirit_fire");
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Damageable)) {
            return;
        }
        if (entityDamageByEntityEvent.getDamager() instanceof Player) {
            Player player = (Player)entityDamageByEntityEvent.getDamager();
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            if (skilledPlayer.getForm() != EidolonForm.DARK) {
                return;
            }
            Integer n = prepped.getOrDefault(player.getUniqueId(), null);
            if (n != null && n > 0) {
                double d = this.getExtraScaling(skilledPlayer, "dark-scaling", entityDamageByEntityEvent);
                double d2 = (double)prepped.get(player.getUniqueId()).intValue() / d;
                entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d2);
                SkillsLang.Skill_Eidolon_Spirit_Expell.sendMessage(player, "%damage%", MathUtils.roundToDigits(d2, 2));
                prepped.remove(player.getUniqueId());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonDefend(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity() instanceof Player) {
            Player player = (Player)entityDamageByEntityEvent.getEntity();
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            if (skilledPlayer.getForm() == EidolonForm.LIGHT) {
                double d = this.getScaling(skilledPlayer, new Object[0]);
                if (d > 50.0) {
                    d = 50.0;
                }
                int n = (int)(entityDamageByEntityEvent.getDamage() * (d / 100.0)) + 1;
                entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() * (1.0 - d / 100.0));
                if (prepped.containsKey(player.getUniqueId())) {
                    prepped.put(player.getUniqueId(), prepped.get(player.getUniqueId()) + n);
                } else {
                    prepped.put(player.getUniqueId(), n);
                }
            }
        }
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%dark%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer, "dark-scaling").getString())};
    }
}

