/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.skills.abilities.Ability;
import org.skills.abilities.eidolon.EidolonForm;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.Cooldown;
import org.skills.utils.StringUtils;

public class EidolonSpectre
extends Ability {
    public EidolonSpectre() {
        super("Eidolon", "spectre");
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Damageable)) {
            return;
        }
        if (entityDamageByEntityEvent.getDamager() instanceof Player) {
            Player player = (Player)entityDamageByEntityEvent.getDamager();
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            if (!Cooldown.isInCooldown(player.getUniqueId(), "EShield") && skilledPlayer.getForm() == EidolonForm.DARK) {
                int n = (int)this.getScaling(skilledPlayer, new Object[0]);
                String string = "";
                StringUtils.replace((String)"", (String)"s", (String)"s");
                double d = this.getExtraScaling(skilledPlayer, "dark-scaling", new Object[0]);
                double d2 = 1.0 + d / 100.0;
                entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() * d2);
                SkillsLang.Skill_Eidolon_Attack_Boost.sendMessage(player, "%damage%", "" + d);
                new Cooldown(player.getUniqueId(), "EShield", n, TimeUnit.SECONDS);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonDefend(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity() instanceof Player) {
            Player player = (Player)entityDamageByEntityEvent.getEntity();
            SkilledPlayer skilledPlayer = this.checkup(player);
            if (skilledPlayer == null) {
                return;
            }
            if (!Cooldown.isInCooldown(player.getUniqueId(), "EShield") && skilledPlayer.getForm() == EidolonForm.LIGHT) {
                int n = (int)this.getScaling(skilledPlayer, new Object[0]);
                int n2 = (int)this.getExtraScaling(skilledPlayer, "speed", new Object[0]);
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > 3) {
                    n2 = 3;
                }
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 60, n2));
                SkillsLang.Skill_Eidolon_Shield_Speed.sendMessage(player, new Object[0]);
                new Cooldown(player.getUniqueId(), "EShield", n, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%speed%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer, "speed").getString()), "%dark%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer, "dark-scaling").getString())};
    }
}

