/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;

public class EidolonPurify
extends Ability {
    public EidolonPurify() {
        super("Eidolon", "purify");
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        double d;
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d2 = this.getScaling(skilledPlayer, entityDamageByEntityEvent) * this.getExtraScaling(skilledPlayer, "hp", entityDamageByEntityEvent);
        if (d2 > (d = this.getExtraScaling(skilledPlayer, "max", entityDamageByEntityEvent))) {
            d2 = d;
        }
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d2);
        if (player.isOnline()) {
            skilledPlayer.setEnergy(skilledPlayer.getEnergy() + entityDamageByEntityEvent.getDamage() / this.getExtraScaling(skilledPlayer, "energy-per-damage", entityDamageByEntityEvent));
        }
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%max%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer, "max").getString())};
    }
}

