/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import java.awt.Color;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import org.skills.abilities.Ability;
import org.skills.abilities.eidolon.EidolonForm;
import org.skills.api.events.EidolonImbalanceChangeEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.SkillsLang;
import org.skills.utils.versionsupport.VersionSupport;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class EidolonPassive
extends Ability {
    public EidolonPassive() {
        super("Eidolon", "passive");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEidolonChangeForm(EidolonImbalanceChangeEvent eidolonImbalanceChangeEvent) {
        Player player = eidolonImbalanceChangeEvent.getPlayer();
        if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d = this.getScaling(skilledPlayer, new Object[0]);
        Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> VersionSupport.heal(eidolonImbalanceChangeEvent.getPlayer(), d));
        if (!skilledPlayer.showReadyMessage()) {
            return;
        }
        if (eidolonImbalanceChangeEvent.getNewForm() == EidolonForm.LIGHT) {
            ParticleDisplay.simple(player.getLocation(), Particle.REDSTONE).withColor(Color.WHITE, 1.0f).offset(0.5, 0.5, 0.5).withCount(100).spawn();
            XSound.play(player, this.getExtra(skilledPlayer, "sounds.imbalance.light").getString());
            SkillsLang.Skill_Eidolon_Turn_Light.sendMessage(player, new Object[0]);
        } else {
            ParticleDisplay.simple(player.getLocation(), Particle.REDSTONE).withColor(Color.BLACK, 1.0f).withCount(100).offset(0.5, 0.5, 0.5).spawn();
            XSound.play(player, this.getExtra(skilledPlayer, "sounds.imbalance.dark").getString());
            SkillsLang.Skill_Eidolon_Turn_Dark.sendMessage(player, new Object[0]);
        }
    }
}

