/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.utils.Cooldown;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class EidolonDefile
extends ActiveAbility {
    private static final String DEFILE = "DEFILE";
    private static final HashMap<UUID, Integer> imbalanced = new HashMap();

    public EidolonDefile() {
        super("Eidolon", "defile", false);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEidolonAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        int n = (int)this.getScaling(skilledPlayer, new Object[0]);
        imbalanced.put(entity.getUniqueId(), n);
        int n2 = (int)this.getExtraScaling(skilledPlayer, "time", new Object[0]);
        if (n2 <= 0) {
            n2 = 2;
        }
        new Cooldown(entityDamageByEntityEvent.getEntity().getUniqueId(), DEFILE, n2, TimeUnit.SECONDS);
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() * this.getExtraScaling(skilledPlayer, "damage", "imbalance", imbalanced.get(entity.getUniqueId())));
        Location location = entity.getLocation();
        entity.getWorld().playEffect(location, Effect.STEP_SOUND, (Object)Material.LAPIS_BLOCK);
        entity.getWorld().playEffect(location, Effect.STEP_SOUND, (Object)Material.COAL_BLOCK);
        entity.getWorld().playEffect(location, Effect.STEP_SOUND, (Object)Material.IRON_BLOCK);
        XParticle.atom(4, 2.0, 30.0, ParticleDisplay.simple(location, Particle.DRIP_LAVA), ParticleDisplay.simple(location, Particle.FLAME));
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageReceive(EntityDamageEvent entityDamageEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageEvent.getEntity().getLocation())) {
            return;
        }
        if (imbalanced.containsKey(entityDamageEvent.getEntity().getUniqueId())) {
            if (Cooldown.isInCooldown(entityDamageEvent.getEntity().getUniqueId(), DEFILE)) {
                entityDamageEvent.setDamage(entityDamageEvent.getDamage() * (double)(1.0f + (float)imbalanced.get(entityDamageEvent.getEntity().getUniqueId()).intValue() / 100.0f));
                entityDamageEvent.getEntity().getWorld().playEffect(entityDamageEvent.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.LAPIS_BLOCK);
                entityDamageEvent.getEntity().getWorld().playEffect(entityDamageEvent.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.COAL_BLOCK);
                entityDamageEvent.getEntity().getWorld().playEffect(entityDamageEvent.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.IRON_BLOCK);
            } else {
                imbalanced.remove(entityDamageEvent.getEntity().getUniqueId());
            }
        }
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%time%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer, "time").getString())};
    }
}

