/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.eidolon;

import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.skills.abilities.Ability;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.managers.LastHitManager;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class EidolonBlackhole
extends ActiveAbility {
    private static final String BLACKHOLE = "BLACKHOLE";

    public EidolonBlackhole() {
        super("Eidolon", "blackhole", true);
    }

    @Override
    protected void useSkill(final Player player) {
        final SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        final Location location = player.getEyeLocation();
        final ParticleDisplay particleDisplay = ParticleDisplay.simple(location, Particle.PORTAL);
        particleDisplay.count = 100;
        particleDisplay.extra = 3.0;
        particleDisplay.offset(0.0, 0.0, 0.0);
        final ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location.clone().add(0.0, -1.5, 0.0), EntityType.ARMOR_STAND);
        armorStand.setVisible(false);
        armorStand.setMarker(true);
        armorStand.getEquipment().setHelmet(XMaterial.DRAGON_EGG.parseItem());
        EidolonBlackhole.addEntity((Entity)armorStand);
        final Set<EntityType> set = this.getEntityList(skilledPlayer, "blacklisted");
        XSound.ENTITY_ENDER_DRAGON_DEATH.play(location, 0.4f, 0.0f);
        final long l = (long)this.getExtraScaling(skilledPlayer, "quality", new Object[0]);
        new BukkitRunnable(){
            final double range;
            final double gravity;
            final double distance;
            final double damage;
            long duration;
            int repeat;
            double rotation;
            {
                this.range = EidolonBlackhole.this.getExtraScaling(skilledPlayer, "range", new Object[0]);
                this.gravity = EidolonBlackhole.this.getExtraScaling(skilledPlayer, "gravity", new Object[0]);
                this.distance = EidolonBlackhole.this.getExtraScaling(skilledPlayer, "distance", new Object[0]);
                this.damage = EidolonBlackhole.this.getScaling(skilledPlayer, new Object[0]);
                this.duration = (long)EidolonBlackhole.this.getExtraScaling(skilledPlayer, "duration", new Object[0]);
                this.repeat = 0;
                this.rotation = 0.0;
            }

            public void run() {
                for (Entity entity : location.getWorld().getNearbyEntities(location, this.range, this.range, this.range)) {
                    Player player2;
                    if (!(entity instanceof LivingEntity) || !entity.isValid() || entity.getType() == EntityType.ARMOR_STAND || entity.getUniqueId().equals(player.getUniqueId()) || entity instanceof Player && ((player2 = (Player)entity).getGameMode() == GameMode.CREATIVE || player2.getGameMode() == GameMode.SPECTATOR) || !ServiceHandler.canFight(entity, (Entity)player)) continue;
                    if (!set.contains(entity.getType())) {
                        player2 = location.toVector().subtract(entity.getLocation().toVector()).normalize();
                        entity.setVelocity(player2.multiply(this.gravity));
                    }
                    if (!(entity.getLocation().distance(location) < this.distance)) continue;
                    LastHitManager.damage((LivingEntity)entity, player, this.damage);
                    if (!(entity instanceof Player)) continue;
                    EidolonBlackhole.this.applyEffects(skilledPlayer, (LivingEntity)entity);
                }
                particleDisplay.spawn();
                armorStand.setHeadPose(new EulerAngle(this.rotation, this.rotation * -1.0, 0.0));
                this.rotation += 0.1;
                if (this.rotation > 360.0) {
                    this.rotation = 0.0;
                }
                this.repeat = (int)((long)this.repeat + l);
                if (this.repeat >= 20) {
                    this.repeat = 0;
                    XSound.BLOCK_PORTAL_TRAVEL.play(location, 0.1f, 2.0f);
                }
                this.duration -= l;
                if (this.duration <= 0L) {
                    this.cancel();
                    armorStand.remove();
                    Ability.removeEntity((Entity)armorStand);
                    TNTPrimed tNTPrimed = (TNTPrimed)location.getWorld().spawnEntity(location, EntityType.PRIMED_TNT);
                    tNTPrimed.setMetadata(EidolonBlackhole.BLACKHOLE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)player.getUniqueId()));
                    tNTPrimed.setYield((float)EidolonBlackhole.this.getExtraScaling(skilledPlayer, "yield", new Object[0]));
                    tNTPrimed.setFuseTicks(0);
                }
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 0L, l);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void tntDmaage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof TNTPrimed)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!entity.hasMetadata(BLACKHOLE)) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)((UUID)((MetadataValue)entity.getMetadata(BLACKHOLE).get(0)).value()));
        if (player != null && ServiceHandler.areFriendly(entityDamageByEntityEvent.getEntity(), (Entity)player)) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }
}

