/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.devourer;

import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XPotion;

public class DevourerPassive
extends Ability {
    private static final String PASSIVE = "DEV_PASSIVE";

    public DevourerPassive() {
        super("Devourer", "passive");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPoisonAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (MathUtils.hasChance((int)this.getExtraScaling(skilledPlayer, "chance", entityDamageByEntityEvent))) {
            LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
            Optional<XPotion> optional = XPotion.matchXPotion(this.getExtra(skilledPlayer).getString("effect"));
            if (optional.isPresent()) {
                double d = this.getScaling(skilledPlayer, entityDamageByEntityEvent);
                int n = (int)this.getExtraScaling(skilledPlayer, "duration", entityDamageByEntityEvent) * 20;
                int n2 = (int)(this.getExtraScaling(skilledPlayer, "amplifier", entityDamageByEntityEvent) - 1.0);
                livingEntity.addPotionEffect(new PotionEffect(optional.get().parsePotionEffectType(), n, n2));
                livingEntity.setMetadata(PASSIVE, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)d));
                Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> livingEntity.removeMetadata(PASSIVE, (Plugin)SkillsPro.get()), (long)n);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPoisoned(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.POISON && entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.WITHER) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        List list = entity.getMetadata(PASSIVE);
        if (list.isEmpty()) {
            return;
        }
        double d = ((MetadataValue)list.get(0)).asDouble();
        entityDamageEvent.setDamage(entityDamageEvent.getDamage() + d);
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%chance%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer).getString("chance")), "%duration%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer).getString("duration")), "%amplifier%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer).getString("amplifier"))};
    }
}

