/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.devourer;

import com.google.common.base.Enums;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.Cooldown;
import org.skills.utils.LocationUtils;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class DevourerHook
extends ActiveAbility {
    private static final Map<UUID, UUID> HOOKS = new HashMap<UUID, UUID>();
    private static final Set<UUID> HOOKED = new HashSet<UUID>();

    public DevourerHook() {
        super("Devourer", "hook", true);
    }

    @Override
    protected void useSkill(Player player) {
        SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        Entity entity = player.getWorld().spawnEntity(player.getEyeLocation(), (EntityType)Enums.getIfPresent(EntityType.class, (String)this.getExtra(skilledPlayer, "hook").getString()).orNull());
        entity.setVelocity(player.getLocation().getDirection().multiply(skilledPlayer.getImprovementLevel(this) + 1));
        HOOKS.put(entity.getUniqueId(), player.getUniqueId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL && HOOKED.remove(entityDamageEvent.getEntity().getUniqueId())) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void hookDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (HOOKED.remove(entityDamageByEntityEvent.getDamager().getUniqueId())) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onSprint(PlayerMoveEvent playerMoveEvent) {
        if (MathUtils.isInteger(playerMoveEvent.getTo().getY())) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)SkillsPro.get(), () -> {
                if (Cooldown.isInCooldown(playerMoveEvent.getPlayer().getUniqueId(), "DD")) {
                    return;
                }
                HOOKED.remove(playerMoveEvent.getPlayer().getUniqueId());
            }, 2L);
        }
    }

    @EventHandler
    public void onHooked(ProjectileHitEvent projectileHitEvent) {
        Object object;
        Projectile projectile = projectileHitEvent.getEntity();
        UUID uUID = HOOKS.remove(projectile.getUniqueId());
        if (uUID == null) {
            return;
        }
        if (projectileHitEvent.getHitEntity() != null) {
            HOOKED.add(projectile.getUniqueId());
        }
        final Player player = Bukkit.getPlayer((UUID)uUID);
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (player.getLocation().distance(projectile.getLocation()) > this.getExtraScaling(skilledPlayer, "range", new Object[0])) {
            return;
        }
        Block block = projectileHitEvent.getHitBlock();
        if (block != null) {
            object = XMaterial.matchXMaterial(block.getType());
            List<String> list = this.getExtra(skilledPlayer, "untargetable-blocks").getStringList();
            if (list.contains(((Enum)object).name())) {
                return;
            }
        }
        LocationUtils.whoooosh((Entity)player, projectile.getLocation(), 0.15, 0.05, 0.15);
        object = ParticleDisplay.simple(player.getLocation(), Particle.CLOUD);
        ((ParticleDisplay)object).count = 50;
        ((ParticleDisplay)object).offset(1.0, 0.0, 1.0);
        ((ParticleDisplay)object).spawn();
        try {
            XSound.ENTITY_FISHING_BOBBER_RETRIEVE.play((Entity)player);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (skilledPlayer.getImprovementLevel(this) > 1) {
            HOOKED.add(player.getUniqueId());
            new Cooldown(player.getUniqueId(), "DD", 2L, TimeUnit.SECONDS);
        }
        new BukkitRunnable(){
            final ParticleDisplay dis;
            int times;
            {
                this.dis = ParticleDisplay.simple(player.getLocation(), Particle.SMOKE_LARGE);
                this.times = 0;
            }

            public void run() {
                ++this.times;
                this.dis.spawn(player.getLocation());
                if (this.times > 20) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
    }
}

