/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.devourer;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.LocationUtils;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class DevourerGliders
extends Ability {
    private static final Set<UUID> TEMP_FLY = new HashSet<UUID>();
    private static final Set<UUID> JUMPING = new HashSet<UUID>();

    public DevourerGliders() {
        super("Devourer", "gliders");
    }

    public static void onDisable() {
        TEMP_FLY.forEach(uUID -> {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player != null) {
                player.setAllowFlight(false);
            }
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onSprint(final PlayerMoveEvent playerMoveEvent) {
        if (!LocationUtils.hasMoved(playerMoveEvent.getFrom(), playerMoveEvent.getTo())) {
            return;
        }
        final Player player = playerMoveEvent.getPlayer();
        if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
            return;
        }
        if (ServiceHandler.isNPC((Entity)player)) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                SkilledPlayer skilledPlayer = DevourerGliders.this.checkup(player);
                if (skilledPlayer == null) {
                    return;
                }
                UUID uUID = player.getUniqueId();
                int n = skilledPlayer.getImprovementLevel(DevourerGliders.this);
                boolean bl = MathUtils.isInteger(playerMoveEvent.getTo().getY());
                if (bl) {
                    JUMPING.remove(uUID);
                    if (TEMP_FLY.remove(uUID)) {
                        Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> {
                            player.setAllowFlight(false);
                            player.setFlying(false);
                        });
                    }
                }
                if ((double)n >= DevourerGliders.this.getExtraScaling(skilledPlayer, "double-jump-level", new Object[0]) && player.getGameMode() != GameMode.CREATIVE && !JUMPING.contains(uUID) && !bl && !player.getAllowFlight()) {
                    TEMP_FLY.add(uUID);
                    JUMPING.add(uUID);
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> player.setAllowFlight(true));
                }
                if (!player.isSprinting()) {
                    return;
                }
                if (!player.hasPotionEffect(XPotion.SPEED.parsePotionEffectType())) {
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> DevourerGliders.this.applyEffects(skilledPlayer, (LivingEntity)player));
                }
            }
        }.runTaskAsynchronously((Plugin)SkillsPro.get());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
            return;
        }
        if (ServiceHandler.isNPC((Entity)player)) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if ((double)skilledPlayer.getImprovementLevel(this) < this.getExtraScaling(skilledPlayer, "double-jump-level", new Object[0])) {
            return;
        }
        ParticleDisplay particleDisplay = ParticleDisplay.simple(player.getLocation(), Particle.SMOKE_LARGE);
        particleDisplay.count = 70;
        particleDisplay.offset(0.5, 0.0, 0.5);
        particleDisplay.spawn();
        entityDamageEvent.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onDoubleJump(PlayerToggleFlightEvent playerToggleFlightEvent) {
        if (!playerToggleFlightEvent.isFlying()) {
            return;
        }
        Player player = playerToggleFlightEvent.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (skilledPlayer.getImprovementLevel(this) < 3) {
            return;
        }
        if (TEMP_FLY.remove(player.getUniqueId())) {
            player.setAllowFlight(false);
            player.setFlying(false);
            playerToggleFlightEvent.setCancelled(true);
        }
        player.setVelocity(player.getLocation().getDirection().multiply(1.3).setY(this.getScaling(skilledPlayer, new Object[0])));
        ParticleDisplay particleDisplay = ParticleDisplay.simple(player.getLocation(), Particle.CLOUD);
        particleDisplay.count = 70;
        particleDisplay.offset(0.5, 0.5, 0.5);
        particleDisplay.spawn();
    }
}

