/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.devourer;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.Ability;
import org.skills.api.events.SkillToggleAbilityEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.SkillsLang;
import org.skills.managers.LastHitManager;
import org.skills.utils.Cooldown;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class DevourerCloak
extends Ability {
    private static final String INVIS = "DEVOURER_INVIS";
    private static final String NEUTRAL = "DEVOURER_NEUTRAL";

    public DevourerCloak() {
        super("Devourer", "cloak");
    }

    private static void activateInvisibility(SkilledPlayer skilledPlayer, Player player) {
        if (!player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            if (skilledPlayer.showReadyMessage()) {
                player.sendMessage(SkillsLang.Skill_Devourer_Invis_Enabled.parse(new Object[0]));
            }
            XParticle.helix(SkillsPro.get(), 4, 1.0, 0.1, 1.0, 4, 3, true, false, new ParticleDisplay(Particle.CLOUD, player.getLocation()));
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 200, 1), true);
    }

    @Override
    public void start() {
        DevourerCloak.addTask(new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    SkilledPlayer skilledPlayer;
                    GameMode gameMode = player.getGameMode();
                    if (gameMode == GameMode.CREATIVE || gameMode == GameMode.SPECTATOR || SkillsConfig.isInDisabledWorld(player.getLocation()) || (skilledPlayer = DevourerCloak.this.checkup(player)) == null || Cooldown.isInCooldown(player.getUniqueId(), DevourerCloak.INVIS)) continue;
                    Bukkit.getScheduler().runTask((Plugin)SkillsPro.get(), () -> DevourerCloak.activateInvisibility(skilledPlayer, player));
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 100L, 100L));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDevourerAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player = LastHitManager.getOwningPlayer(entityDamageByEntityEvent.getDamager());
        if (player == null) {
            return;
        }
        if (!player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        int n = skilledPlayer.getImprovementLevel(this);
        if (skilledPlayer.showReadyMessage()) {
            SkillsLang.Skill_Devourer_Invis_Disabled.sendMessage(player, new Object[0]);
        }
        if (n > 2) {
            entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + this.getScaling(skilledPlayer, new Object[0]));
        }
        player.removePotionEffect(PotionEffectType.INVISIBILITY);
        XParticle.helix(SkillsPro.get(), 4, 1.0, 0.1, 1.0, 4, 3, true, false, new ParticleDisplay(Particle.CLOUD, player.getLocation()));
        new Cooldown(player.getUniqueId(), INVIS, (long)this.getExtraScaling(skilledPlayer, "cooldown.invisibility", new Object[0]), TimeUnit.SECONDS);
        if (this.getExtra(skilledPlayer).getBoolean("neutrality") && n > 1 && entityDamageByEntityEvent.getEntityType() != EntityType.PLAYER) {
            if (!Cooldown.isInCooldown(player.getUniqueId(), NEUTRAL)) {
                SkillsLang.Skill_Devourer_Neutrality_Disabled.sendMessage(player, new Object[0]);
            }
            new Cooldown(player.getUniqueId(), NEUTRAL, (long)this.getExtraScaling(skilledPlayer, "cooldown.neutrality", new Object[0]), TimeUnit.SECONDS);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SkillsPro.get(), () -> {
            if (!Cooldown.isInCooldown(player.getUniqueId(), INVIS)) {
                DevourerCloak.activateInvisibility(skilledPlayer, player);
            }
            if (n > 1 && !Cooldown.isInCooldown(player.getUniqueId(), NEUTRAL)) {
                SkillsLang.Skill_Devourer_Neutrality_Enabled.sendMessage(player, new Object[0]);
            }
        }, 600L);
    }

    @EventHandler
    public void onSkillToggleDisabled(SkillToggleAbilityEvent skillToggleAbilityEvent) {
        if (skillToggleAbilityEvent.getAbility() instanceof DevourerCloak && skillToggleAbilityEvent.isDisabled()) {
            Player player = skillToggleAbilityEvent.getPlayer();
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTarget(EntityTargetEvent entityTargetEvent) {
        if (SkillsConfig.isInDisabledWorld(entityTargetEvent.getEntity().getLocation())) {
            return;
        }
        if (!(entityTargetEvent.getTarget() instanceof Player)) {
            return;
        }
        if (Arrays.asList(EntityType.ENDER_DRAGON, EntityType.WITHER, EntityType.ENDERMAN, EntityType.GUARDIAN, EntityType.ENDERMITE).contains(entityTargetEvent.getEntityType()) || entityTargetEvent.getEntityType().name().equals("ELDER_GUARDIAN")) {
            return;
        }
        Player player = (Player)entityTargetEvent.getTarget();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (!this.getExtra(skilledPlayer).getBoolean("neutrality")) {
            return;
        }
        if (skilledPlayer == null || skilledPlayer.getImprovementLevel(this) < 2) {
            return;
        }
        if (!Cooldown.isInCooldown(player.getUniqueId(), NEUTRAL)) {
            entityTargetEvent.setCancelled(true);
        }
    }
}

