/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.arbalist;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;

public class ArbalistMinions
extends ActiveAbility {
    private static final String MINION = "ARBALIST_MINION";
    private static final Map<UUID, Set<Entity>> MINIONS = new HashMap<UUID, Set<Entity>>();

    public ArbalistMinions() {
        super("Arbalist", "minions", false);
    }

    private static void killMinion(LivingEntity livingEntity) {
        livingEntity.getWorld().spawnParticle(Particle.DRAGON_BREATH, livingEntity.getLocation(), 100, 0.5, 0.5, 0.5, 0.05);
        livingEntity.setHealth(0.0);
        ArbalistMinions.removeEntity((Entity)livingEntity);
    }

    @EventHandler
    public void onTargetChange(EntityTargetEvent entityTargetEvent) {
        if (entityTargetEvent.getEntityType() != EntityType.SKELETON && XMaterial.supports(14) && entityTargetEvent.getEntityType() != EntityType.PILLAGER) {
            return;
        }
        Entity entity = entityTargetEvent.getEntity();
        List list = entity.getMetadata(MINION);
        if (list.isEmpty()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)((MetadataValue)list.get(0)).value();
        if (entityTargetEvent.getTarget() == null || livingEntity.getEntityId() != entityTargetEvent.getTarget().getEntityId()) {
            entityTargetEvent.setTarget((Entity)livingEntity);
        }
    }

    @EventHandler
    public void onMinionTargetDeath(EntityDeathEvent entityDeathEvent) {
        Set<Entity> set = MINIONS.get(entityDeathEvent.getEntity().getUniqueId());
        if (set != null) {
            for (Entity entity : set) {
                if (!entity.isValid() || !(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                ArbalistMinions.killMinion(livingEntity);
            }
        }
        if (entityDeathEvent.getEntity().hasMetadata(MINION)) {
            entityDeathEvent.getEntity().getWorld().spawnParticle(Particle.DRAGON_BREATH, entityDeathEvent.getEntity().getLocation(), 100, 0.5, 0.5, 0.5, 0.05);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        int n;
        if (!(entityDamageByEntityEvent.getDamager() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entityDamageByEntityEvent.getDamager();
        if (!(arrow.getShooter() instanceof Player)) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getLocation())) {
            return;
        }
        final Player player = (Player)arrow.getShooter();
        SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        int n2 = skilledPlayer.getImprovementLevel(this);
        boolean bl = XMaterial.supports(14) && n2 > 2;
        Location location = player.getLocation();
        EntityType entityType = bl ? EntityType.PILLAGER : EntityType.SKELETON;
        ItemStack itemStack = bl ? XMaterial.CROSSBOW.parseItem() : XMaterial.BOW.parseItem();
        final XSound xSound = bl ? XSound.ENTITY_PILLAGER_AMBIENT : XSound.ENTITY_SKELETON_STEP;
        int n3 = (int)this.getExtraScaling(skilledPlayer, "enchants.arrow-damage", new Object[0]);
        if (n3 > 0) {
            itemStack.addUnsafeEnchantment(Enchantment.ARROW_DAMAGE, n3);
        }
        if ((n = (int)this.getExtraScaling(skilledPlayer, "enchants.flame", new Object[0])) > 0) {
            itemStack.addUnsafeEnchantment(Enchantment.ARROW_FIRE, n);
        }
        new BukkitRunnable(){
            int times = 5;

            public void run() {
                xSound.play((Entity)player);
                --this.times;
                if (this.times == 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 5L);
        HashSet hashSet = new HashSet();
        for (int i = (int)this.getExtraScaling(skilledPlayer, "amount", new Object[0]); i > 0; --i) {
            int n4 = MathUtils.randInt(1, 3);
            int n5 = MathUtils.randInt(1, 3);
            Location location2 = location.clone().add((double)n4, 0.0, (double)n5);
            if (!location2.getBlock().getType().name().endsWith("AIR")) {
                location2 = player.getLocation();
            }
            location2.getWorld().spawnParticle(Particle.PORTAL, location2.clone().add(0.0, 1.0, 0.0), 500, 0.0, 0.0, 0.0, 1.0);
            Location location3 = location2;
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
                if (!entity.isValid()) {
                    atomicBoolean.set(true);
                    return;
                }
                Location location2 = location3.setDirection(entity.getLocation().toVector().subtract(location3.toVector()));
                Monster monster = (Monster)location3.getWorld().spawnEntity(location2, entityType);
                monster.setMetadata(MINION, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), (Object)entity));
                monster.setTarget((LivingEntity)entity);
                monster.setRemoveWhenFarAway(true);
                monster.setCustomName(MessageHandler.colorize("&c" + player.getName() + " Minion"));
                monster.setCustomNameVisible(true);
                EntityEquipment entityEquipment = monster.getEquipment();
                entityEquipment.setItemInMainHand(itemStack);
                this.applyEffects(skilledPlayer, (LivingEntity)monster);
                this.applyEffects(skilledPlayer, (LivingEntity)player);
                hashSet.add(monster);
                ArbalistMinions.addEntity((Entity)monster);
            }, 40L);
            if (atomicBoolean.get()) break;
        }
        MINIONS.put(entity.getUniqueId(), hashSet);
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> {
            for (Entity entity : hashSet) {
                if (!entity.isValid()) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                ArbalistMinions.killMinion(livingEntity);
            }
        }, (long)(this.getExtraScaling(skilledPlayer, "time", new Object[0]) * 20.0));
    }
}

