/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.arbalist;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;

public class ArbalistFireCrossbow
extends ActiveAbility {
    public static final String ARBALIST_FIRECROSSBOW = "ARBALIST_CROSS";

    public ArbalistFireCrossbow() {
        super("Arbalist", "fire_crossbow", true);
        if (!XMaterial.supports(14)) {
            Bukkit.getPluginManager().registerEvents((Listener)new Old(), (Plugin)SkillsPro.get());
        }
    }

    @Override
    public void useSkill(final Player player) {
        int n;
        SkilledPlayer skilledPlayer = this.activeCheckup(player);
        if (skilledPlayer == null) {
            return;
        }
        Vector vector = player.getEyeLocation().getDirection();
        final double d = this.getExtraScaling(skilledPlayer, "range", new Object[0]);
        int n2 = (int)this.getExtraScaling(skilledPlayer, "knockback", new Object[0]);
        int n3 = (int)this.getExtraScaling(skilledPlayer, "fire", new Object[0]);
        vector.multiply(d);
        final Arrow arrow = (Arrow)player.launchProjectile(Arrow.class, vector);
        arrow.setInvulnerable(true);
        arrow.setBounce(false);
        arrow.setFireTicks(n3);
        arrow.setKnockbackStrength(n2);
        arrow.setMetadata(ARBALIST_FIRECROSSBOW, (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
        if (XMaterial.supports(14)) {
            arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        }
        if (MathUtils.hasChance(n = (int)this.getExtraScaling(skilledPlayer, "shotgun.chance", new Object[0]))) {
            int n4 = (int)this.getExtraScaling(skilledPlayer, "shotgun.amount.min", new Object[0]);
            int n5 = (int)this.getExtraScaling(skilledPlayer, "shotgun.amount.max", new Object[0]);
            double d2 = (int)this.getExtraScaling(skilledPlayer, "shotgun.offset", new Object[0]);
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            for (int i = 0; i < threadLocalRandom.nextInt(n4, n5); ++i) {
                Arrow arrow2 = (Arrow)player.launchProjectile(Arrow.class, vector.clone().add(new Vector(threadLocalRandom.nextDouble(-d2, d2), threadLocalRandom.nextDouble(-d2, d2), threadLocalRandom.nextDouble(-d2, d2))));
                if (!XMaterial.supports(14)) continue;
                arrow2.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            }
        }
        arrow.setGlowing(true);
        if (MathUtils.hasChance((int)this.getExtraScaling(skilledPlayer, "critical-chance", new Object[0]))) {
            arrow.setCritical(true);
        }
        XSound.ENTITY_FIREWORK_ROCKET_LARGE_BLAST_FAR.play((Entity)player);
        player.spawnParticle(Particle.LAVA, player.getLocation(), (int)(d * 2.0) + 10, 0.1, 0.1, 0.1, 1.0);
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                ++this.i;
                if (this.i > 4) {
                    this.cancel();
                }
                if (arrow.isOnGround()) {
                    this.cancel();
                }
                if (XMaterial.isNewVersion()) {
                    player.playNote(arrow.getLocation(), Instrument.CHIME, Note.natural((int)1, (Note.Tone)Note.Tone.values()[this.i]));
                }
                player.spawnParticle(Particle.FLAME, arrow.getLocation(), (int)(d * 2.0), 0.01, 0.01, 0.01, 0.1);
            }
        }.runTaskTimer((Plugin)SkillsPro.get(), 5L, 5L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onTargetHit(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!(entity instanceof Projectile)) {
            return;
        }
        if (!entity.hasMetadata(ARBALIST_FIRECROSSBOW)) {
            return;
        }
        Player player = (Player)((Projectile)entity).getShooter();
        if (player == null) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        entityDamageByEntityEvent.setDamage((double)((int)this.getScaling(skilledPlayer, new Object[0])));
        XSound.ENTITY_EXPERIENCE_ORB_PICKUP.play((Entity)player, 2.0f, 0.0f);
        player.spawnParticle(Particle.LAVA, entityDamageByEntityEvent.getEntity().getLocation(), 30, 0.1, 0.1, 0.1, 0.1);
    }

    @EventHandler
    public void onBlockHit(ProjectileHitEvent projectileHitEvent) {
        Projectile projectile = projectileHitEvent.getEntity();
        if (projectileHitEvent.getHitBlock() == null) {
            return;
        }
        if (!projectile.hasMetadata(ARBALIST_FIRECROSSBOW)) {
            return;
        }
        projectile.removeMetadata(ARBALIST_FIRECROSSBOW, (Plugin)SkillsPro.get());
        Player player = (Player)projectile.getShooter();
        if (player == null) {
            return;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (MathUtils.hasChance((int)this.getExtraScaling(skilledPlayer, "explosion-chance", new Object[0]))) {
            TNTPrimed tNTPrimed = (TNTPrimed)player.getLocation().getWorld().spawnEntity(projectileHitEvent.getHitBlock().getLocation(), EntityType.PRIMED_TNT);
            tNTPrimed.setFuseTicks(1);
        }
    }

    private static class Old
    implements Listener {
        private Old() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerPickupItem(PlayerPickupArrowEvent playerPickupArrowEvent) {
            if (playerPickupArrowEvent.getItem().hasMetadata("ARBALIST")) {
                playerPickupArrowEvent.setCancelled(true);
            }
        }
    }
}

