/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.arbalist;

import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;

public class ArbalistDualArrows
extends Ability {
    public ArbalistDualArrows() {
        super("Arbalist", "dual_arrows");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (SkillsConfig.isInDisabledWorld(entityDamageByEntityEvent.getEntity().getWorld())) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Arrow) {
            if (entity.hasMetadata("ARBALIST")) {
                return;
            }
            if (((Arrow)entity).getShooter() instanceof Player) {
                Player player = (Player)((Arrow)entityDamageByEntityEvent.getDamager()).getShooter();
                SkilledPlayer skilledPlayer = this.checkup(player);
                if (skilledPlayer == null) {
                    return;
                }
                double d = this.getScaling(skilledPlayer, entityDamageByEntityEvent);
                entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onArrowLaunch(ProjectileLaunchEvent projectileLaunchEvent) {
        if (SkillsConfig.isInDisabledWorld(projectileLaunchEvent.getEntity().getLocation())) {
            return;
        }
        Projectile projectile = projectileLaunchEvent.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (!MathUtils.hasChance((int)this.getExtraScaling(skilledPlayer, "chance", new Object[0]))) {
            return;
        }
        Vector vector = projectile.getVelocity();
        vector.add(new Vector(MathUtils.rand(-0.5, 0.5), MathUtils.rand(-0.5, 0.5), MathUtils.rand(-0.5, 0.5)));
        Arrow arrow = (Arrow)player.launchProjectile(Arrow.class, vector);
        arrow.setFireTicks((int)this.getExtraScaling(skilledPlayer, "fire", new Object[0]));
        arrow.setMetadata("ARBALIST", (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
    }

    @Override
    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[]{"%chance%", this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer, "chance").getString())};
    }
}

