/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities;

import com.google.common.base.Strings;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.skills.abilities.Ability;
import org.skills.api.events.SkillActiveStateChangeEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XMaterial;

public abstract class ActiveAbility
extends Ability {
    public boolean activateOnReady;

    public ActiveAbility(String string, String string2, boolean bl) {
        super(string, string2);
        this.activateOnReady = bl;
    }

    public String getAbilityReady(SkilledPlayer skilledPlayer) {
        return this.getExtra(skilledPlayer).getString("activation.messages.ready");
    }

    public String getAbilityIdle(SkilledPlayer skilledPlayer) {
        return this.getExtra(skilledPlayer).getString("activation.messages.idle");
    }

    public String getAbilityActivated(SkilledPlayer skilledPlayer) {
        return this.getExtra(skilledPlayer).getString("activation.messages.activated");
    }

    public String getAbilityFinished(SkilledPlayer skilledPlayer) {
        return this.getExtra(skilledPlayer).getString("activation.messages.finished");
    }

    public int getIdle(SkilledPlayer skilledPlayer) {
        return this.getExtra(skilledPlayer).getInt("activation.idle");
    }

    public boolean isAbilityReady(Player player) {
        return SkilledPlayer.getSkilledPlayer((OfflinePlayer)player).isActiveReady();
    }

    public String getActivationKey(SkilledPlayer skilledPlayer) {
        return this.getExtra(skilledPlayer).getString("activation.key");
    }

    protected void useSkill(Player player) {
        this.activeCheckup(player);
    }

    public double getEnergy(SkilledPlayer skilledPlayer) {
        String string = this.getExtra(skilledPlayer).getString("activation.energy");
        return super.getAbsoluteScaling(skilledPlayer, string, new Object[0]);
    }

    public boolean isWeaponAllowed(SkilledPlayer skilledPlayer, ItemStack itemStack) {
        List list = this.getExtra(skilledPlayer).getStringList("activation.items");
        if (list.size() == 0) {
            return true;
        }
        return XMaterial.matchXMaterial(itemStack).isOneOf(list);
    }

    public double getCooldown(SkilledPlayer skilledPlayer) {
        String string = this.getExtra(skilledPlayer).getString("activation.cooldown");
        return super.getAbsoluteScaling(skilledPlayer, string, new Object[0]);
    }

    public void sendMessage(Player player, String string, Object ... objectArray) {
        if (Strings.isNullOrEmpty((String)string)) {
            return;
        }
        String string2 = MessageHandler.replaceVariables(ServiceHandler.translatePlaceholders((OfflinePlayer)player, string), objectArray);
        MessageHandler.sendMessage((CommandSender)player, string2, SkillsConfig.PREFIX.getBoolean());
    }

    public SkilledPlayer activeCheckup(Player player) {
        SkilledPlayer skilledPlayer = super.checkup(player);
        if (skilledPlayer == null) {
            return null;
        }
        if (!skilledPlayer.isActiveReady(this)) {
            return null;
        }
        SkillActiveStateChangeEvent skillActiveStateChangeEvent = new SkillActiveStateChangeEvent(player, this, false);
        Bukkit.getPluginManager().callEvent((Event)skillActiveStateChangeEvent);
        if (skillActiveStateChangeEvent.isCancelled()) {
            return null;
        }
        skilledPlayer.deactivateReady();
        skilledPlayer.setEnergy(skilledPlayer.getEnergy() - this.getEnergy(skilledPlayer));
        skilledPlayer.setCooldown((long)this.getCooldown(skilledPlayer) * 1000L);
        this.sendMessage(player, this.getAbilityActivated(skilledPlayer), new Object[0]);
        return skilledPlayer;
    }
}

