/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities;

import com.google.common.base.Enums;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.skills.abilities.Ability;
import org.skills.abilities.AbilityActivation;
import org.skills.abilities.ActiveAbility;
import org.skills.api.events.CustomHudChangeEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.LocationUtils;
import org.skills.utils.nbt.ItemNBT;
import org.skills.utils.nbt.NBTType;
import org.skills.utils.nbt.NBTWrappers;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.particles.ParticleDisplay;

public class AbilityListener
implements Listener {
    private static boolean activate(Player player, AbilityActivation.ActivationAction activationAction) {
        Object object;
        Object object2;
        if (player.getGameMode() == GameMode.CREATIVE && !player.hasPermission("skills.use-creative")) {
            return false;
        }
        if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
            return false;
        }
        if (SkillsConfig.DISABLE_ABILITIES_IN_REGIONS.getBoolean() && ServiceHandler.isPvPOff(player)) {
            return false;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasSkill()) {
            return false;
        }
        if (skilledPlayer.isActiveReady()) {
            return false;
        }
        Object object3 = null;
        String string = (String)AbilityActivation.ACTIVATIONS.getIfPresent((Object)player.getUniqueId());
        string = string == null ? String.valueOf(activationAction.shortName) : string + String.valueOf(activationAction.shortName);
        int n = string.length();
        String string2 = string.substring(0, n - 1) + 'C';
        ItemStack itemStack = player.getItemInHand();
        for (Ability ability : skilledPlayer.getSkill().getAbilities()) {
            if (ability.isPassive() || skilledPlayer.getImprovementLevel(ability) <= 0 || skilledPlayer.isAbilityDisabled(ability) || !((ActiveAbility)(object2 = (ActiveAbility)ability)).isWeaponAllowed(skilledPlayer, itemStack)) continue;
            object = ((ActiveAbility)object2).getActivationKey(skilledPlayer);
            boolean bl = ((String)object).startsWith(string2);
            if (!((String)object).startsWith(string) && !bl) continue;
            if (bl) {
                if (!player.isSneaking()) {
                    AbilityActivation.ACTIVATIONS.invalidate((Object)player.getUniqueId());
                    return false;
                }
                ++n;
                string = string2 + activationAction.shortName;
            }
            if (n == ((String)object).length()) {
                AbilityActivation.ACTIVATIONS.invalidate((Object)player.getUniqueId());
                object3 = object2;
                break;
            }
            AbilityActivation.ACTIVATIONS.put((Object)player.getUniqueId(), (Object)string);
            return true;
        }
        if (object3 == null) {
            return false;
        }
        if (skilledPlayer.isInCooldown()) {
            XSound.BLOCK_NOTE_BLOCK_BASS.play((Entity)player);
            return true;
        }
        double d = ((ActiveAbility)object3).getEnergy(skilledPlayer);
        if (skilledPlayer.getEnergy() < d) {
            XSound.play(player, skilledPlayer.getSkill().getEnergy().getSoundNotEnough());
            return true;
        }
        object2 = ((ActiveAbility)object3).getAbilityReady(skilledPlayer);
        if (skilledPlayer.showReadyMessage() && object2 != null) {
            ((ActiveAbility)object3).sendMessage(player, (String)object2, new Object[0]);
        }
        if (!skilledPlayer.setActiveReady((ActiveAbility)object3, true)) {
            return true;
        }
        CustomHudChangeEvent.call(player);
        skilledPlayer.setLastAbilityUsed((ActiveAbility)object3);
        if (((ActiveAbility)object3).activateOnReady) {
            ((ActiveAbility)object3).useSkill(player);
            return true;
        }
        object = ParticleDisplay.simple(player.getLocation(), (Particle)Enums.getIfPresent(Particle.class, (String)SkillsConfig.READY_PARTICLE_PARTICLE.getString()).or((Object)Particle.SPELL_WITCH));
        ((ParticleDisplay)object).count = (int)SkillsConfig.READY_PARTICLE_COUNT.eval(skilledPlayer, (Ability)object3);
        double d2 = SkillsConfig.READY_PARTICLE_OFFSET.eval(skilledPlayer, (Ability)object3);
        ((ParticleDisplay)object).offset(d2, d2, d2);
        BukkitTask bukkitTask = new BukkitRunnable((ParticleDisplay)object, player, skilledPlayer){
            final /* synthetic */ ParticleDisplay val$display;
            final /* synthetic */ Player val$player;
            final /* synthetic */ SkilledPlayer val$info;
            {
                this.val$display = particleDisplay;
                this.val$player = player;
                this.val$info = skilledPlayer;
            }

            public void run() {
                this.val$display.spawn(LocationUtils.getHandLocation(this.val$player, true));
                if (!this.val$info.isActiveReady()) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
        XSound.ITEM_ARMOR_EQUIP_DIAMOND.play((Entity)player);
        Object object4 = object3;
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> AbilityListener.lambda$activate$0(bukkitTask, player, skilledPlayer, (ActiveAbility)object4), (long)((ActiveAbility)object3).getIdle(skilledPlayer) * 20L);
        return true;
    }

    @EventHandler
    public void onSneakActivate(PlayerToggleSneakEvent playerToggleSneakEvent) {
        Player player = playerToggleSneakEvent.getPlayer();
        if (player.isSneaking()) {
            AbilityListener.activate(player, AbilityActivation.ActivationAction.SNEAK);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSwordMove(InventoryPickupItemEvent inventoryPickupItemEvent) {
        if (Ability.isSkillEntity((Entity)inventoryPickupItemEvent.getItem())) {
            inventoryPickupItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onQ(PlayerDropItemEvent playerDropItemEvent) {
        if (AbilityListener.activate(playerDropItemEvent.getPlayer(), AbilityActivation.ActivationAction.DROP)) {
            playerDropItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onF(PlayerSwapHandItemsEvent playerSwapHandItemsEvent) {
        if (AbilityListener.activate(playerSwapHandItemsEvent.getPlayer(), AbilityActivation.ActivationAction.SWITCH)) {
            playerSwapHandItemsEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onSkillActivate(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Action action = playerInteractEvent.getAction();
        if (action == Action.PHYSICAL) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack != null) {
            Object object;
            NBTWrappers.NBTTagCompound nBTTagCompound;
            try {
                nBTTagCompound = ItemNBT.getTag(itemStack);
                nBTTagCompound.get("Skill_Item", NBTType.STRING);
            }
            catch (Exception exception) {
                MessageHandler.sendConsolePluginMessage("&cA NBT error has occurred! Please report this to the developer.");
                exception.printStackTrace();
            }
            nBTTagCompound = itemStack.getType();
            if ((action == Action.RIGHT_CLICK_BLOCK || action == Action.RIGHT_CLICK_AIR) && nBTTagCompound.isEdible()) {
                return;
            }
            XMaterial xMaterial = XMaterial.matchXMaterial(itemStack);
            if (xMaterial.isOneOf(SkillsConfig.PREVENT_ACTIVATION_ITEMS.getStringList())) {
                return;
            }
            if (action == Action.RIGHT_CLICK_BLOCK) {
                object = playerInteractEvent.getClickedBlock();
                if (itemStack.getType().isBlock()) {
                    return;
                }
                if (XMaterial.matchXMaterial(object.getType()).isOneOf(SkillsConfig.PREVENT_ACTIVATION_BLOCKS.getStringList())) {
                    return;
                }
            }
            object = action.name().startsWith("LEFT") ? AbilityActivation.ActivationAction.LEFT_CLICK : AbilityActivation.ActivationAction.RIGHT_CLICK;
            AbilityListener.activate(player, (AbilityActivation.ActivationAction)((Object)object));
        }
    }

    private static /* synthetic */ void lambda$activate$0(BukkitTask bukkitTask, Player player, SkilledPlayer skilledPlayer, ActiveAbility activeAbility) {
        bukkitTask.cancel();
        if (!player.isOnline()) {
            return;
        }
        if (skilledPlayer.setActiveReady(activeAbility, false)) {
            String string = activeAbility.getAbilityIdle(skilledPlayer);
            if (skilledPlayer.showReadyMessage() && string != null) {
                player.sendMessage(string);
            }
            XSound.ITEM_ARMOR_EQUIP_CHAIN.play((Entity)player);
        }
    }
}

