/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.skills.abilities.AbilityManager;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsSkillConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.SkillManager;
import org.skills.types.Stat;
import org.skills.utils.MathUtils;
import org.skills.utils.xseries.XPotion;

public abstract class Ability
implements Listener {
    private static final Map<Integer, Entity> ENTITIES = new HashMap<Integer, Entity>();
    private static final Set<Integer> TASKS = new HashSet<Integer>();
    protected final String name;
    private final String skill;

    public Ability(String string, String string2) {
        this.skill = string;
        this.name = string2.equalsIgnoreCase("passive") ? string.toLowerCase(Locale.ENGLISH) + "_passive" : string2;
    }

    public static void addEntity(Entity entity) {
        ENTITIES.put(entity.getEntityId(), entity);
    }

    public static boolean isSkillEntity(Entity entity) {
        return ENTITIES.containsKey(entity.getEntityId());
    }

    public static void addAllEntities(Collection<? extends Entity> collection) {
        for (Entity entity : collection) {
            Ability.addEntity(entity);
        }
    }

    public static void removeEntity(Entity entity) {
        ENTITIES.remove(entity.getEntityId());
    }

    public static String getScalingColor(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (Stat stat : Stat.STATS) {
            if (!string.contains(stat.getNode().toLowerCase(Locale.ENGLISH))) continue;
            return MessageHandler.colorize(stat.getColor());
        }
        return "";
    }

    public static boolean addTask(BukkitTask bukkitTask) {
        return TASKS.add(bukkitTask.getTaskId());
    }

    public static void reload() {
        BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
        Iterator<Object> iterator = TASKS.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            bukkitScheduler.cancelTask(n);
        }
        for (Ability ability : AbilityManager.getAbilities().values()) {
            HandlerList.unregisterAll((Listener)ability);
        }
    }

    public static void onDisable() {
        ENTITIES.values().forEach(Entity::remove);
    }

    public Set<EntityType> getEntityList(SkilledPlayer skilledPlayer, String string) {
        List<String> list = this.getExtra(skilledPlayer, string).getStringList();
        EnumSet<EntityType> enumSet = EnumSet.noneOf(EntityType.class);
        for (String string2 : list) {
            EntityType entityType = (EntityType)Enums.getIfPresent(EntityType.class, (String)string2.toUpperCase(Locale.ENGLISH)).orNull();
            if (entityType == null) continue;
            enumSet.add(entityType);
        }
        return enumSet;
    }

    public String getTitle(SkilledPlayer skilledPlayer) {
        return SkillsLang.valueOf("ABILITY_" + this.name.toUpperCase(Locale.ENGLISH) + "_TITLE").parse(skilledPlayer.getOfflinePlayer());
    }

    public String getDescription(SkilledPlayer skilledPlayer) {
        return SkillsLang.valueOf("ABILITY_" + this.name.toUpperCase(Locale.ENGLISH) + "_DESCRIPTION").parse(skilledPlayer.getOfflinePlayer());
    }

    public String getScalingDescription(SkilledPlayer skilledPlayer, String string) {
        return Ability.getScalingColor(string) + MathUtils.roundToDigits(this.getAbsoluteScaling(skilledPlayer, string, new Object[0]), 2);
    }

    public void start() {
    }

    public String translate(SkilledPlayer skilledPlayer, String string) {
        return this.getScalingDescription(skilledPlayer, this.getExtra(skilledPlayer, string).getString());
    }

    public String getScalingEquation(SkilledPlayer skilledPlayer, String string) {
        String string2 = this.getExtra(skilledPlayer).getString(string);
        if (string2 == null) {
            MessageHandler.sendConsolePluginMessage("&cMissing scaling in skills.yml for&8: &e" + skilledPlayer.getSkillName() + " &7-> &eabilities &7-> &e" + this.name + " &7-> &e" + string);
            return "0";
        }
        return string2;
    }

    public double getScaling(SkilledPlayer skilledPlayer, Object ... objectArray) {
        String string = this.getScalingEquation(skilledPlayer, "scaling");
        return this.getAbsoluteScaling(skilledPlayer, string, objectArray);
    }

    public double getScaling(SkilledPlayer skilledPlayer, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        return this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent.getDamage(), "hp", livingEntity.getHealth(), "maxHp", livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
    }

    public PotionEffect parseEquationPotion(SkilledPlayer skilledPlayer, @Nullable String string) {
        if (Strings.isNullOrEmpty((String)string) || string.equalsIgnoreCase("none")) {
            return null;
        }
        String[] stringArray = StringUtils.split((String)StringUtils.deleteWhitespace((String)string), (char)',');
        Optional<XPotion> optional = XPotion.matchXPotion(stringArray[0]);
        if (!optional.isPresent()) {
            return null;
        }
        PotionEffectType potionEffectType = optional.get().parsePotionEffectType();
        if (potionEffectType == null) {
            return null;
        }
        int n = 2400;
        int n2 = 0;
        try {
            if (stringArray.length > 3 && !MathUtils.hasChance((int)this.getAbsoluteScaling(skilledPlayer, stringArray[3], new Object[0]))) {
                return null;
            }
            if (stringArray.length > 1) {
                n = (int)(this.getAbsoluteScaling(skilledPlayer, stringArray[1], new Object[0]) * 20.0);
                if (stringArray.length > 2) {
                    n2 = (int)(this.getAbsoluteScaling(skilledPlayer, stringArray[2], new Object[0]) - 1.0);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new PotionEffect(potionEffectType, n, n2);
    }

    public List<PotionEffect> getEffects(SkilledPlayer skilledPlayer, String string) {
        ArrayList<PotionEffect> arrayList = new ArrayList<PotionEffect>();
        List list = this.getExtra(skilledPlayer).getStringList(string);
        if (list == null || list.isEmpty()) {
            return new ArrayList<PotionEffect>();
        }
        for (String string2 : list) {
            PotionEffect potionEffect = this.parseEquationPotion(skilledPlayer, string2);
            if (potionEffect == null) continue;
            arrayList.add(potionEffect);
        }
        return arrayList;
    }

    public List<PotionEffect> applyEffects(SkilledPlayer skilledPlayer, String string, LivingEntity livingEntity) {
        List<PotionEffect> list = this.getEffects(skilledPlayer, string);
        livingEntity.addPotionEffects(list);
        return list;
    }

    public List<PotionEffect> applyEffects(SkilledPlayer skilledPlayer, LivingEntity livingEntity) {
        return this.applyEffects(skilledPlayer, "effects", livingEntity);
    }

    public String getTranslatedScaling(SkilledPlayer skilledPlayer, String string, Object ... objectArray) {
        Objects.requireNonNull(string, "One of the scalings for " + skilledPlayer.getSkillName() + " -> " + this.name + " is missing");
        String string2 = ServiceHandler.translatePlaceholders(skilledPlayer.getOfflinePlayer(), string);
        string2 = StringUtils.replace((String)string2, (String)"lvl", (String)String.valueOf(skilledPlayer.getImprovementLevel(this)));
        string2 = MessageHandler.replaceVariables(string2, objectArray);
        for (Stat stat : Stat.STATS) {
            String string3 = String.valueOf(skilledPlayer.getStat(stat));
            string2 = MessageHandler.replace(string2, stat.getNode().toLowerCase(Locale.ENGLISH), string3);
            string2 = MessageHandler.replace(string2, stat.getNode().toUpperCase(Locale.ENGLISH), string3);
        }
        return string2;
    }

    public double getAbsoluteScaling(SkilledPlayer skilledPlayer, String string, Object ... objectArray) {
        return MathUtils.evaluateEquation(this.getTranslatedScaling(skilledPlayer, string, objectArray));
    }

    public ConfigurationSection getExtra(SkilledPlayer skilledPlayer) {
        return skilledPlayer.getSkill().getAdapter().getConfig().getConfigurationSection("abilities." + this.name.replace('_', '-'));
    }

    public SkillsSkillConfig getExtra(String string, String string2) {
        return new SkillsSkillConfig(SkillManager.getSkill(string).getAdapter().getConfig(), "abilities." + this.name.replace('_', '-') + '.' + string2);
    }

    public SkillsSkillConfig getExtra(SkilledPlayer skilledPlayer, String string) {
        return new SkillsSkillConfig(skilledPlayer.getSkill().getAdapter().getConfig(), "abilities." + this.name.replace('_', '-') + '.' + string);
    }

    public double getExtraScaling(SkilledPlayer skilledPlayer, String string, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
        return this.getExtraScaling(skilledPlayer, string, "damage", entityDamageByEntityEvent.getDamage(), "hp", livingEntity.getHealth(), "maxHp", livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
    }

    public double getExtraScaling(SkilledPlayer skilledPlayer, String string, Object ... objectArray) {
        Objects.requireNonNull(skilledPlayer, "Player info cannot be null");
        String string2 = this.getScalingEquation(skilledPlayer, string);
        return this.getAbsoluteScaling(skilledPlayer, string2, objectArray);
    }

    public int getCost(SkilledPlayer skilledPlayer) {
        String string = this.getExtra(skilledPlayer).getString("cost");
        if (string == null) {
            return 0;
        }
        return (int)this.getAbsoluteScaling(skilledPlayer, string, new Object[0]);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Ability)) {
            return false;
        }
        Ability ability = (Ability)object;
        return this.name.equals(ability.name);
    }

    public SkilledPlayer checkup(Player player) {
        GameMode gameMode = player.getGameMode();
        if (gameMode == GameMode.SPECTATOR) {
            return null;
        }
        if (gameMode == GameMode.CREATIVE && !player.hasPermission("skills.use-creative")) {
            return null;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.getSkill().hasAbility(this)) {
            return null;
        }
        if (skilledPlayer.isAbilityDisabled(this)) {
            return null;
        }
        if (!this.name.endsWith("passive") && skilledPlayer.getImprovementLevel(this) < 1) {
            return null;
        }
        if (!(this.isPassive() || ((ActiveAbility)this).activateOnReady || skilledPlayer.isActiveReady())) {
            return null;
        }
        if (SkillsConfig.isInDisabledWorld(player.getWorld())) {
            return null;
        }
        if (ServiceHandler.isInRegion(player, this.getDisabledRegions(skilledPlayer))) {
            return null;
        }
        return skilledPlayer;
    }

    public List<String> getDisabledRegions(SkilledPlayer skilledPlayer) {
        return this.getExtra(skilledPlayer).getStringList("disabled-regions");
    }

    public Object[] applyEdits(SkilledPlayer skilledPlayer) {
        return new Object[0];
    }

    public Object[] copyEdits(SkilledPlayer skilledPlayer, Object[] objectArray) {
        Object[] objectArray2 = this.applyEdits(skilledPlayer);
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
        arrayList.addAll(Arrays.asList(objectArray2));
        return arrayList.toArray();
    }

    public int getRequiredLevel(SkilledPlayer skilledPlayer) {
        String string = this.getExtra(skilledPlayer).getString("required-level");
        if (Strings.isNullOrEmpty((String)string)) {
            return 0;
        }
        return (int)this.getAbsoluteScaling(skilledPlayer, string, new Object[0]);
    }

    public boolean canUse(SkilledPlayer skilledPlayer) {
        return this.getRequiredLevel(skilledPlayer) <= skilledPlayer.getLevel();
    }

    public boolean isPassive() {
        return !(this instanceof ActiveAbility);
    }

    public String getName() {
        return this.name;
    }

    public String getSkill() {
        return this.skill;
    }
}

