/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.tree.basic;

import java.util.List;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.exception.SkillTreeException;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.gui.tool.GUIType;
import studio.magemonkey.fabled.tree.basic.InventoryTree;

public class BasicVerticalTree
extends InventoryTree {
    private int width;

    public BasicVerticalTree(Fabled api, FabledClass tree) {
        super(api, tree);
    }

    @Override
    public void arrange(List<Skill> skills) throws SkillTreeException {
        this.skillSlots.clear();
        skills.sort(comparator);
        this.height = 0;
        int size = skills.size();
        for (int i = 0; i < size; ++i) {
            Skill skill = skills.get(i);
            if (skill.getSkillReq() != null) continue;
            if (i == 8) {
                Fabled.inst().getLogger().warning(this.getClass().getSimpleName() + " for " + this.tree.getName() + " would be too big and could not be completed. Try changing the tree type of the class.");
                break;
            }
            this.skillSlots.put(i, skill);
            this.width = this.placeChildren(skills, skill, i + 9, 0);
        }
        this.height = Math.max(1, Math.min(Fabled.getConfig("gui").getConfig().getInt(GUIType.SKILL_TREE.getPrefix() + this.tree.getName() + ".rows", this.skillSlots.size() == 0 ? 1 : ((Integer)this.skillSlots.lastKey() + 9) / 9), 6));
    }

    private int placeChildren(List<Skill> skills, Skill skill, int slot, int depth) {
        if (depth + 1 > this.height) {
            this.height = depth + 1;
        }
        int width = 0;
        for (Skill s : skills) {
            if (s.getSkillReq() == null || !s.getSkillReq().equalsIgnoreCase(skill.getName())) continue;
            if ((slot + width) % 9 == 8) {
                Fabled.inst().getLogger().warning(this.getClass().getSimpleName() + " for " + this.tree.getName() + " would be too big and could not be completed. Try changing the tree type of the class.");
                break;
            }
            this.skillSlots.put(slot + width, s);
            width += this.placeChildren(skills, s, slot + width + 9, depth + 1);
        }
        return Math.max(width, 1);
    }
}

