/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.tree;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.exception.SkillTreeException;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.log.Logger;

public abstract class SkillTree {
    protected final Fabled api;
    protected final FabledClass tree;

    public SkillTree(Fabled api, FabledClass tree) {
        this.api = api;
        this.tree = tree;
    }

    public boolean canShow(Player player, Skill skill) {
        return (!skill.canAutoLevel(0) || !skill.canAutoLevel(1) || skill.canCast() || Fabled.getSettings().isShowingAutoSkills()) && skill.isAllowed(player);
    }

    public void arrange() throws SkillTreeException {
        ArrayList<Skill> skills = new ArrayList<Skill>();
        for (Skill skill : this.tree.getSkills()) {
            if (!Fabled.isSkillRegistered(skill)) {
                Logger.invalid("Failed to add skill to tree - " + skill + ": Skill does not exist");
                continue;
            }
            if (!Fabled.getSettings().isShowingAutoSkills() && !skill.canCast() && skill.canAutoLevel(0) && skill.canAutoLevel(1)) continue;
            skills.add(skill);
        }
        this.arrange(skills);
    }

    protected abstract void arrange(List<Skill> var1) throws SkillTreeException;

    public abstract boolean hasSkill(Skill var1);
}

