/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.thread;

import java.util.ConcurrentModificationException;
import java.util.Objects;
import org.bukkit.plugin.IllegalPluginAccessException;
import studio.magemonkey.fabled.thread.IThreadTask;
import studio.magemonkey.fabled.thread.TaskList;

public class MainThread
extends Thread {
    private static final TaskList tasks = new TaskList();
    private long time = System.currentTimeMillis();
    private boolean enabled = true;
    private boolean print = true;

    public MainThread() {
        this.start();
    }

    @Override
    public void run() {
        while (this.enabled) {
            try {
                tasks.iterator();
                while (tasks.hasNext()) {
                    if (!tasks.next().tick()) continue;
                    tasks.remove();
                }
                long current = System.currentTimeMillis();
                this.time += 50L;
                MainThread.sleep(Math.max(1L, this.time - current));
            }
            catch (ConcurrentModificationException current) {
            }
            catch (Exception ex) {
                if (!this.print) continue;
                ex.printStackTrace();
                this.print = false;
            }
        }
    }

    public void disable() {
        for (IThreadTask task : tasks) {
            try {
                task.run();
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {}
        }
        tasks.clear();
        this.enabled = false;
    }

    public static void register(IThreadTask task) {
        Objects.requireNonNull(task, "Cannot register a null task");
        tasks.add(task);
    }
}

