/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.task;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.FilterType;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.hook.PlaceholderAPIHook;
import studio.magemonkey.fabled.hook.PluginChecker;
import studio.magemonkey.fabled.language.RPGFilter;
import studio.magemonkey.fabled.log.LogType;
import studio.magemonkey.fabled.log.Logger;
import studio.magemonkey.fabled.thread.RepeatThreadTask;

public class GUITask
extends RepeatThreadTask {
    private final boolean levelMana;
    private final boolean levelLevel;
    private final boolean foodMana;
    private final boolean foodExp;
    private final boolean forceScaling;
    private final boolean oldHealth;
    private final boolean useAction;
    private final String actionText;

    public GUITask(Fabled api) {
        super(5, 5);
        String levelBar = Fabled.getSettings().getLevelBar().toLowerCase();
        this.levelMana = levelBar.equals("mana");
        this.levelLevel = levelBar.equals("level");
        String foodBar = Fabled.getSettings().getFoodBar().toLowerCase();
        this.foodMana = foodBar.equals("mana");
        this.foodExp = foodBar.equals("exp");
        this.forceScaling = Fabled.getSettings().isForceScaling();
        this.oldHealth = Fabled.getSettings().isOldHealth();
        this.useAction = Fabled.getSettings().isUseActionBar();
        this.actionText = TextFormatter.colorString((String)Fabled.getSettings().getActionText());
        Logger.log(LogType.GUI, 1, "GUI Settings: " + this.levelMana + "/" + this.levelLevel + "/" + this.foodMana + "/" + this.foodExp + "/" + this.useAction + "/" + this.actionText);
        if (this.useAction || this.levelMana || this.levelLevel || this.foodMana || this.foodExp || this.forceScaling) {
            return;
        }
        this.expired = true;
    }

    @Override
    public void run() {
        Logger.log(LogType.GUI, 1, "Updating GUI (" + Bukkit.getOnlinePlayers().size() + " players)...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerClass main;
            if (!Fabled.getSettings().isWorldEnabled(player.getWorld()) || !Fabled.hasPlayerData((OfflinePlayer)player)) continue;
            PlayerData data = Fabled.getData((OfflinePlayer)player);
            if (this.forceScaling) {
                if (this.oldHealth) {
                    player.setHealthScale(20.0);
                } else {
                    player.setHealthScale(player.getMaxHealth());
                }
            }
            if (this.levelMana) {
                Logger.log(LogType.GUI, 2, "Updating level bar with mana");
                if (data.getMaxMana() == 0.0) {
                    player.setLevel(0);
                    player.setExp(0.0f);
                } else {
                    player.setLevel((int)data.getMana());
                    player.setExp(Math.min(0.999f, (float)(0.999 * data.getMana() / data.getMaxMana())));
                }
            } else if (this.levelLevel) {
                Logger.log(LogType.GUI, 2, "Updating level bar with class level/exp");
                if (!data.hasClass()) {
                    player.setLevel(0);
                    player.setExp(0.0f);
                } else {
                    main = data.getMainClass();
                    player.setLevel(main.getLevel());
                    player.setExp(Math.min(0.999f, (float)main.getExp() / (float)main.getRequiredExp()));
                }
            }
            if (this.foodMana) {
                Logger.log(LogType.GUI, 2, "Updating food bar with mana");
                player.setSaturation(20.0f);
                if (data.getMaxMana() == 0.0) {
                    player.setFoodLevel(20);
                } else {
                    player.setFoodLevel((int)Math.ceil(20.0 * data.getMana() / data.getMaxMana()));
                }
            } else if (this.foodExp) {
                Logger.log(LogType.GUI, 2, "Updating food bar with class level/exp");
                player.setSaturation(20.0f);
                if (!data.hasClass()) {
                    player.setFoodLevel(0);
                } else {
                    main = data.getMainClass();
                    player.setFoodLevel((int)Math.floor(20.0 * main.getExp() / (double)main.getRequiredExp()));
                }
            }
            if (!this.useAction || !data.hasClass()) continue;
            Logger.log(LogType.GUI, 2, "Updating action bar");
            main = data.getMainClass();
            String filtered = (main.getData().hasActionBarText() ? main.getData().getActionBarText() : this.actionText).replace("{combo}", (CharSequence)Fabled.getLanguage().getMessage("Combo.gui-display", true, FilterType.COLOR, new CustomFilter[]{RPGFilter.COMBO.setReplacement(data.getComboData().getCurrentComboString())}).get(0)).replace("{class}", main.getData().getPrefix()).replace("{level}", "" + main.getLevel()).replace("{exp}", "" + (int)main.getExp()).replace("{expReq}", "" + main.getRequiredExp()).replace("{expLeft}", "" + (int)Math.ceil((double)main.getRequiredExp() - main.getExp())).replace("{mana}", "" + (int)data.getMana()).replace("{maxMana}", "" + (int)data.getMaxMana()).replace("{name}", player.getName()).replace("{health}", "" + (int)player.getHealth()).replace("{maxHealth}", "" + (int)player.getMaxHealth()).replace("{attr}", "" + data.getAttributePoints()).replace("{sp}", "" + main.getPoints());
            while (filtered.contains("{value:")) {
                int index = filtered.indexOf("{value:");
                int end = filtered.indexOf(125, index);
                String key = filtered.substring(index + 7, end);
                String value = DynamicSkill.getCastData((LivingEntity)player).get(key);
                filtered = filtered.replace("{value:" + key + "}", value == null ? "None" : value);
            }
            if (PluginChecker.isPlaceholderAPIActive()) {
                filtered = PlaceholderAPIHook.format(filtered, player);
            }
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)filtered));
        }
    }
}

