/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.manager;

import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.mccore.chat.Chat;
import studio.magemonkey.codex.mccore.chat.Prefix;
import studio.magemonkey.codex.mccore.scoreboard.Board;
import studio.magemonkey.codex.mccore.scoreboard.BoardManager;
import studio.magemonkey.codex.mccore.scoreboard.PlayerBoards;
import studio.magemonkey.codex.mccore.scoreboard.StatBoard;
import studio.magemonkey.codex.mccore.scoreboard.StatHolder;
import studio.magemonkey.codex.mccore.scoreboard.Team;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.data.CustomScoreboardHolder;
import studio.magemonkey.fabled.util.PlaceholderUtil;

public class ClassBoardManager {
    public static void clear(Player player) {
        Chat.getPlayerData((String)player.getName()).clearPluginPrefix("Fabled");
        BoardManager.getPlayerBoards((String)player.getName()).removeBoards("Fabled");
        BoardManager.clearTeam((String)player.getName());
        BoardManager.clearScore((String)player.getName());
    }

    public static void clearAll() {
        BoardManager.clearPluginBoards((String)"Fabled");
    }

    public static void update(PlayerData player, String prefix, ChatColor braceColor) {
        try {
            Chat.getPlayerData((String)player.getPlayerName()).setPluginPrefix(new Prefix("Fabled", prefix, braceColor));
            PlayerBoards boards = BoardManager.getPlayerBoards((String)player.getPlayerName());
            boards.removeBoards("Fabled");
            BoardManager.clearTeam((String)player.getPlayerName());
            if (Fabled.getSettings().isShowScoreboard()) {
                StatBoard board = new StatBoard(PlaceholderUtil.colorizeAndReplace(Fabled.getSettings().getScoreboardTitle(), (OfflinePlayer)player.getPlayer()), "Fabled");
                CustomScoreboardHolder holder = new CustomScoreboardHolder(player.getPlayer());
                board.addStats((StatHolder)holder);
                boards.addBoard((Board)board);
            }
            if (Fabled.getSettings().isShowClassName()) {
                BoardManager.setTeam((String)player.getPlayerName(), (String)player.getMainClass().getData().getName());
            }
            if (Fabled.getSettings().isShowClassLevel()) {
                BoardManager.setBelowNameScore((String)player.getPlayerName(), (int)player.getMainClass().getLevel());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void registerClass(FabledClass c) {
        if (Fabled.getSettings().isShowClassName()) {
            String name = c.getName();
            if (name.length() > 16) {
                name = name.substring(0, 16);
            }
            BoardManager.registerTeam((Team)new Team(name, c.getPrefix() + ChatColor.RESET + " ", null));
        }
    }

    public static void updateLevel(PlayerData data) {
        if (Fabled.getSettings().isShowClassLevel() && data.hasClass()) {
            BoardManager.setBelowNameScore((String)data.getPlayerName(), (int)data.getMainClass().getLevel());
        }
    }

    public static void registerText() {
        if (Fabled.getSettings().isShowClassLevel()) {
            BoardManager.init();
            BoardManager.setTextBelowNames((String)Fabled.getSettings().getLevelText());
        }
    }
}

