/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.config.CommentedConfig;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.dynamic.EffectComponent;
import studio.magemonkey.fabled.gui.tool.GUIData;
import studio.magemonkey.fabled.gui.tool.GUIPage;
import studio.magemonkey.fabled.gui.tool.GUITool;
import studio.magemonkey.fabled.log.LogType;
import studio.magemonkey.fabled.log.Logger;
import studio.magemonkey.fabled.manager.IAttributeManager;
import studio.magemonkey.fabled.manager.ProAttribute;

public class AttributeManager
implements IAttributeManager {
    public static final String HEALTH = "health";
    public static final String MANA = "mana";
    public static final String MANA_REGEN = "mana-regen";
    public static final String PHYSICAL_DAMAGE = "physical-damage";
    public static final String MELEE_DAMAGE = "melee-damage";
    public static final String PROJECTILE_DAMAGE = "projectile-damage";
    public static final String PHYSICAL_DEFENSE = "physical-defense";
    public static final String MELEE_DEFENSE = "melee-defense";
    public static final String PROJECTILE_DEFENSE = "projectile-defense";
    public static final String SKILL_DAMAGE = "skill-damage";
    public static final String SKILL_DEFENSE = "skill-defense";
    public static final String MOVE_SPEED = "move-speed";
    public static final String ATTACK_SPEED = "attack-speed";
    public static final String ARMOR = "armor";
    public static final String LUCK = "luck";
    public static final String ARMOR_TOUGHNESS = "armor-toughness";
    public static final String EXPERIENCE = "exp";
    public static final String HUNGER = "hunger";
    public static final String HUNGER_HEAL = "hunger-heal";
    public static final String COOLDOWN = "cooldown";
    public static final String KNOCKBACK_RESIST = "knockback-resist";
    private final Map<String, ProAttribute> attributes = new LinkedHashMap<String, ProAttribute>();
    private final Map<String, ProAttribute> lookup = new HashMap<String, ProAttribute>();
    private final Map<String, List<ProAttribute>> byStat = new HashMap<String, List<ProAttribute>>();
    private final Map<String, List<ProAttribute>> byComponent = new HashMap<String, List<ProAttribute>>();

    @Override
    public ProAttribute getAttribute(String key) {
        return this.lookup.get(key.toLowerCase());
    }

    @Override
    public List<ProAttribute> forStat(String key) {
        return this.byStat.get(key.toLowerCase());
    }

    @Override
    public List<ProAttribute> forComponent(EffectComponent component, String key) {
        return this.byComponent.get(component.getKey() + "-" + key.toLowerCase());
    }

    @Override
    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    @Override
    public Set<String> getLookupKeys() {
        return this.lookup.keySet();
    }

    @Override
    public String normalize(String key) {
        ProAttribute proAttribute = this.lookup.get(key.toLowerCase());
        if (proAttribute == null) {
            throw new IllegalArgumentException("Invalid attribute - " + key);
        }
        return proAttribute.getKey();
    }

    public void load(Fabled api) {
        CommentedConfig config = new CommentedConfig((JavaPlugin)api, "attributes");
        config.saveDefaultConfig();
        DataSection data = config.getConfig();
        Logger.log(LogType.ATTRIBUTE_LOAD, 1, "Loading attributes...");
        for (String key : data.keys()) {
            Logger.log(LogType.ATTRIBUTE_LOAD, 2, "  - " + key);
            ProAttribute proAttribute = new ProAttribute(data.getSection(key), key);
            this.attributes.put(proAttribute.getKey(), proAttribute);
            this.lookup.put(proAttribute.getKey(), proAttribute);
            this.lookup.put(proAttribute.getName().toLowerCase(), proAttribute);
        }
        GUIData attribs = GUITool.getAttributesMenu();
        if (!attribs.isValid()) {
            int i = 0;
            GUIPage page = attribs.getPage(0);
            for (String key : this.attributes.keySet()) {
                if (i >= 54) continue;
                page.set(i++, key);
            }
            attribs.resize((this.attributes.size() + 8) / 9);
        }
    }

    @Override
    public void addByComponent(String key, ProAttribute proAttribute) {
        this.byComponent.computeIfAbsent(key, k -> new ArrayList()).add(proAttribute);
    }

    @Override
    public void addByStat(String key, ProAttribute proAttribute) {
        this.byStat.computeIfAbsent(key, k -> new ArrayList()).add(proAttribute);
    }

    @Override
    public Map<String, ProAttribute> getAttributes() {
        return this.attributes;
    }
}

