/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener.attribute;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ExpSource;
import studio.magemonkey.fabled.api.enums.ManaSource;
import studio.magemonkey.fabled.api.event.PhysicalDamageEvent;
import studio.magemonkey.fabled.api.event.PlayerExperienceGainEvent;
import studio.magemonkey.fabled.api.event.PlayerLevelUpEvent;
import studio.magemonkey.fabled.api.event.PlayerManaGainEvent;
import studio.magemonkey.fabled.api.event.SkillDamageEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.hook.CitizensHook;
import studio.magemonkey.fabled.hook.DivinityHook;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.MainListener;
import studio.magemonkey.fabled.log.LogType;
import studio.magemonkey.fabled.log.Logger;

public class AttributeListener
extends FabledListener {
    public static final String PHYSICAL = "physical";

    @Override
    public void init() {
        MainListener.registerJoin(this::onJoin);
    }

    public void onJoin(Player player) {
        this.updatePlayer(Fabled.getData((OfflinePlayer)player));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRespawn(PlayerRespawnEvent event) {
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        this.updatePlayer(Fabled.getData((OfflinePlayer)event.getPlayer()));
    }

    @EventHandler
    public void onLevelUp(PlayerLevelUpEvent event) {
        this.updatePlayer(event.getPlayerData());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onManaRegen(PlayerManaGainEvent event) {
        if (event.getSource() == ManaSource.REGEN) {
            double newAmount = event.getPlayerData().scaleStat("mana-regen", event.getAmount());
            Logger.log(LogType.MANA, 3, "Attributes scaled mana gain to " + newAmount);
            event.setAmount(newAmount);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPhysicalDamage(PhysicalDamageEvent event) {
        Player player;
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
            ItemStack item = player.getInventory().getItemInMainHand();
            if (DivinityHook.isDivinity(item)) {
                return;
            }
            if (CitizensHook.isNPC((Entity)player)) {
                return;
            }
            PlayerData data = Fabled.getData((OfflinePlayer)player);
            double newAmount = data.scaleStat("physical-damage", event.getDamage());
            newAmount = event.isProjectile() ? data.scaleStat("projectile-damage", newAmount) : data.scaleStat("melee-damage", newAmount);
            event.setDamage(newAmount);
        }
        if (event.getTarget() instanceof Player) {
            player = (Player)event.getTarget();
            if (CitizensHook.isNPC((Entity)player)) {
                return;
            }
            PlayerData data = Fabled.getData((OfflinePlayer)player);
            double newAmount = data.scaleStat("physical-defense", event.getDamage());
            newAmount = event.isProjectile() ? data.scaleStat("projectile-defense", newAmount) : data.scaleStat("melee-defense", newAmount);
            event.setDamage(newAmount);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSkillDamage(SkillDamageEvent event) {
        double newAmount;
        double firstPass;
        String classified;
        PlayerData data;
        Player player;
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
            if (CitizensHook.isNPC((Entity)player)) {
                return;
            }
            data = Fabled.getData((OfflinePlayer)player);
            if (event.getClassification().equalsIgnoreCase(PHYSICAL)) {
                event.setDamage(data.scaleStat("physical-damage", event.getDamage()));
            } else {
                classified = "skill-damage-" + event.getClassification();
                firstPass = data.scaleStat(classified, event.getDamage());
                newAmount = data.scaleStat("skill-damage", firstPass);
                event.setDamage(newAmount);
            }
        }
        if (event.getTarget() instanceof Player) {
            player = (Player)event.getTarget();
            if (CitizensHook.isNPC((Entity)player)) {
                return;
            }
            data = Fabled.getData((OfflinePlayer)player);
            if (event.getClassification().equalsIgnoreCase(PHYSICAL)) {
                event.setDamage(data.scaleStat("physical-defense", event.getDamage()));
            } else {
                classified = "skill-defense-" + event.getClassification();
                firstPass = data.scaleStat(classified, event.getDamage());
                newAmount = data.scaleStat("skill-defense", firstPass);
                event.setDamage(newAmount);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (CitizensHook.isNPC((Entity)player)) {
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        event.setDamage(data.scaleStat("defense-" + event.getCause().name().toLowerCase(), event.getDamage()));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onExp(PlayerExperienceGainEvent event) {
        if (event.getSource() != ExpSource.COMMAND) {
            double newExp = event.getPlayerData().scaleStat("exp", event.getExp());
            event.setExp(newExp);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        boolean oldEnabled = Fabled.getSettings().isWorldEnabled(event.getFrom());
        boolean newEnabled = Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if ((!oldEnabled || newEnabled) && !oldEnabled && newEnabled) {
            this.updatePlayer(Fabled.getData((OfflinePlayer)event.getPlayer()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onHungerChange(FoodLevelChangeEvent event) {
        Player player = (Player)event.getEntity();
        if (event.getFoodLevel() < player.getFoodLevel()) {
            PlayerData data = Fabled.getData((OfflinePlayer)player);
            int lost = data.subtractHungerValue(player.getFoodLevel() - event.getFoodLevel());
            event.setFoodLevel(player.getFoodLevel() - lost);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onHungerHeal(EntityRegainHealthEvent event) {
        if (event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            PlayerData data = Fabled.getData((OfflinePlayer)player);
            double scaled = data.scaleStat("hunger-heal", event.getAmount());
            event.setAmount(scaled);
        }
    }

    private void updatePlayer(PlayerData data) {
        data.updatePlayerStat(data.getPlayer());
    }
}

