/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import studio.magemonkey.fabled.api.DefaultCombatProtection;
import studio.magemonkey.fabled.api.event.PlayerBlockDamageEvent;
import studio.magemonkey.fabled.listener.FabledListener;

public class ShieldBlockListener
extends FabledListener {
    private final HashMap<UUID, Entity> volatileMap = new HashMap();

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player) || DefaultCombatProtection.isFakeDamageEvent(event)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!player.isBlocking()) {
            return;
        }
        final UUID player_uuid = player.getUniqueId();
        this.volatileMap.put(player_uuid, event.getDamager());
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                ShieldBlockListener.this.volatileMap.remove(player_uuid);
            }
        }, 100L);
    }

    @EventHandler
    public void onStat(PlayerStatisticIncrementEvent event) {
        if (!event.getStatistic().equals((Object)Statistic.DAMAGE_BLOCKED_BY_SHIELD)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.volatileMap.containsKey(player.getUniqueId())) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerBlockDamageEvent(this.volatileMap.get(player.getUniqueId()), event));
    }
}

