/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.metadata.Metadatable;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.DefaultCombatProtection;
import studio.magemonkey.fabled.api.enums.ExpSource;
import studio.magemonkey.fabled.api.event.PhysicalDamageEvent;
import studio.magemonkey.fabled.api.event.PlayerLevelUpEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.api.util.BuffManager;
import studio.magemonkey.fabled.api.util.Combat;
import studio.magemonkey.fabled.api.util.FlagManager;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.gui.tool.GUITool;
import studio.magemonkey.fabled.hook.CitizensHook;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.ListenerUtil;
import studio.magemonkey.fabled.manager.ClassBoardManager;

public class MainListener
extends FabledListener {
    public static final Map<UUID, BukkitTask> loadingPlayers = new HashMap<UUID, BukkitTask>();
    private static final List<Consumer<Player>> JOIN_HANDLERS = new ArrayList<Consumer<Player>>();
    private static final List<Consumer<Player>> CLEAR_HANDLERS = new ArrayList<Consumer<Player>>();

    public static void registerJoin(Consumer<Player> joinHandler) {
        JOIN_HANDLERS.add(joinHandler);
    }

    public static void registerClear(Consumer<Player> joinHandler) {
        CLEAR_HANDLERS.add(joinHandler);
    }

    public static void unload(Player player) {
        if (CitizensHook.isNPC((Entity)player)) {
            return;
        }
        boolean skipSaving = false;
        if (loadingPlayers.containsKey(player.getUniqueId())) {
            loadingPlayers.remove(player.getUniqueId()).cancel();
            skipSaving = true;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        if (Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            data.setOnPreviewStop(null);
            data.record(player);
            data.stopPassives(player);
        }
        FlagManager.clearFlags((LivingEntity)player);
        BuffManager.clearData((LivingEntity)player);
        Combat.clearData(player);
        DynamicSkill.clearCastData((LivingEntity)player);
        player.setDisplayName(player.getName());
        player.setWalkSpeed(0.2f);
        Fabled.unloadPlayerData((OfflinePlayer)player, skipSaving);
    }

    public static void init(Player player) {
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        data.init(player);
        GUITool.removeCastItems(player);
        JOIN_HANDLERS.forEach(handler -> handler.accept(player));
    }

    @Override
    public void cleanup() {
        JOIN_HANDLERS.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLogin(AsyncPlayerPreLoginEvent event) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)event.getUniqueId());
        if (Fabled.getSettings().isUseSql() && Fabled.getSettings().getSqlDelay() > 0) {
            Fabled.initFakeData(player);
        } else {
            Fabled.loadPlayerAccounts(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReadyLogin(PlayerLoginEvent event) {
        if (event.getResult() == PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        Fabled.unloadPlayerData((OfflinePlayer)event.getPlayer(), true);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC") || !Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        int delay = Fabled.getSettings().getSqlDelay();
        if (Fabled.getSettings().isUseSql() && delay > 0) {
            BukkitTask task = Fabled.schedule(() -> {
                try {
                    Fabled.reloadPlayerData(player);
                    MainListener.init(player);
                }
                finally {
                    loadingPlayers.remove(event.getPlayer().getUniqueId());
                }
            }, delay);
            loadingPlayers.put(event.getPlayer().getUniqueId(), task);
        } else {
            MainListener.init(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        MainListener.unload(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        FlagManager.clearFlags((LivingEntity)event.getEntity());
        BuffManager.clearData((LivingEntity)event.getEntity());
        DynamicSkill.clearCastData((LivingEntity)event.getEntity());
        if (CitizensHook.isNPC((Entity)event.getEntity())) {
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)event.getEntity());
        if (data.hasClass() && Fabled.getSettings().isWorldEnabled(event.getEntity().getWorld())) {
            data.stopPassives(event.getEntity());
            if (!Fabled.getSettings().shouldIgnoreExpLoss(event.getEntity().getWorld())) {
                data.loseExp();
            }
            if (event.getEntity() instanceof Player) {
                data.getExtraData().clear();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(EntityDeathEvent event) {
        DynamicSkill.clearCastData(event.getEntity());
        FlagManager.clearFlags(event.getEntity());
        BuffManager.clearData(event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUnload(ChunkUnloadEvent event) {
        for (Entity entity : event.getChunk().getEntities()) {
            if (!(entity instanceof LivingEntity) || entity instanceof Player) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            DynamicSkill.clearCastData(livingEntity);
            FlagManager.clearFlags(livingEntity);
            BuffManager.clearData(livingEntity);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent event) {
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        Player player = event.getPlayer();
        if (Fabled.getSettings().isUseOrbs() && player != null && Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            Fabled.getData((OfflinePlayer)player).giveExp(event.getExpToDrop(), ExpSource.BLOCK_BREAK);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSmelt(FurnaceExtractEvent event) {
        Player player = event.getPlayer();
        if (Fabled.getSettings().isUseOrbs() && player != null && Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            Fabled.getData((OfflinePlayer)player).giveExp(event.getExpToDrop(), ExpSource.SMELT);
        }
    }

    @EventHandler
    public void onExpBottleBreak(ExpBottleEvent event) {
        if (!(event.getEntity().getShooter() instanceof Player) || !Fabled.getSettings().isWorldEnabled(((Player)event.getEntity().getShooter()).getWorld())) {
            return;
        }
        Player player = (Player)event.getEntity().getShooter();
        if (CitizensHook.isNPC((Entity)player)) {
            return;
        }
        if (Fabled.getSettings().isUseOrbs()) {
            Fabled.getData((OfflinePlayer)player).giveExp(event.getExperience(), ExpSource.EXP_BOTTLE);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onExpChange(PlayerExpChangeEvent event) {
        if (!Fabled.getSettings().getLevelBar().equalsIgnoreCase("none") && event.getPlayer().hasPermission("fabled.exp") && Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            event.setAmount(0);
        }
    }

    @EventHandler
    public void onLevelUp(PlayerLevelUpEvent event) {
        if (Fabled.getSettings().isShowClassLevel()) {
            ClassBoardManager.updateLevel(event.getPlayerData());
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)event.getPlayer());
        if (data.hasClass() && Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            data.startPassives(event.getPlayer());
            data.updateScoreboard();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof LivingEntity && FlagManager.hasFlag((LivingEntity)event.getEntity(), "immune:" + event.getCause().name())) {
            double multiplier = Fabled.getMetaDouble((Metadatable)event.getEntity(), "sapi_immunity");
            if (multiplier <= 0.0) {
                event.setCancelled(true);
            } else {
                event.setDamage(event.getDamage() * multiplier);
            }
        }
    }

    @EventHandler
    public void onStarve(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.STARVATION && !Fabled.getSettings().getFoodBar().equalsIgnoreCase("none")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSaturationHeal(EntityRegainHealthEvent event) {
        String foodBar = Fabled.getSettings().getFoodBar().toLowerCase();
        if (event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED && Fabled.getSettings().isBlockSaturation() && (foodBar.equals("mana") || foodBar.equals("exp"))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void allyCheck(EntityDamageByEntityEvent event) {
        if (DefaultCombatProtection.isFakeDamageEvent(event) || event.getClass().getSimpleName().equals("DamageCheckEvent")) {
            return;
        }
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player && !Fabled.getSettings().canAttack((LivingEntity)((Player)event.getDamager()), (LivingEntity)((Player)event.getEntity()), event.getCause())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void fakeDamageClear(EntityDamageByEntityEvent event) {
        if (!DefaultCombatProtection.isFakeDamageEvent(event)) {
            return;
        }
        DefaultCombatProtection.externallyCancelled.put(event, event.isCancelled());
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPhysicalDamage(EntityDamageByEntityEvent event) {
        if (Skill.isSkillDamage() || DefaultCombatProtection.isFakeDamageEvent(event) || event.getCause() == EntityDamageEvent.DamageCause.CUSTOM || !(event.getEntity() instanceof LivingEntity) || event.getDamage() <= 0.0) {
            return;
        }
        PhysicalDamageEvent e = new PhysicalDamageEvent(ListenerUtil.getDamager(event), (LivingEntity)event.getEntity(), event.getDamage(), event.getDamager() instanceof Projectile);
        Bukkit.getPluginManager().callEvent((Event)e);
        event.setDamage(e.getDamage());
        if (e.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCombat(EntityDamageByEntityEvent event) {
        LivingEntity damager;
        if (event.getCause() == EntityDamageEvent.DamageCause.CUSTOM || !(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Combat.applyCombat((Player)event.getEntity());
        }
        if ((damager = ListenerUtil.getDamager(event)) instanceof Player) {
            Combat.applyCombat((Player)damager);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChangePre(PlayerChangedWorldEvent event) {
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        boolean oldEnabled = Fabled.getSettings().isWorldEnabled(event.getFrom());
        boolean newEnabled = Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if (!oldEnabled || newEnabled) {
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)event.getPlayer());
        data.clearAllModifiers();
        data.stopPassives(event.getPlayer());
        ClassBoardManager.clear(event.getPlayer());
        if (Fabled.getSettings().isModifyHealth()) {
            event.getPlayer().setMaxHealth((double)Fabled.getSettings().getDefaultHealth());
            event.getPlayer().setHealth((double)Fabled.getSettings().getDefaultHealth());
        }
        if (!Fabled.getSettings().getLevelBar().equalsIgnoreCase("none")) {
            event.getPlayer().setLevel(0);
            event.getPlayer().setExp(0.0f);
        }
        if (!Fabled.getSettings().getFoodBar().equalsIgnoreCase("none")) {
            event.getPlayer().setFoodLevel(20);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        boolean oldEnabled = Fabled.getSettings().isWorldEnabled(event.getFrom());
        boolean newEnabled = Fabled.getSettings().isWorldEnabled(player.getWorld());
        if (newEnabled) {
            if (oldEnabled) {
                Fabled.getData((OfflinePlayer)player).updateHealth(player);
            } else {
                MainListener.init(player);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (!Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getMessage().equals("/clear")) {
            this.handleClear(event.getPlayer());
        } else if (event.getMessage().startsWith("/clear ")) {
            this.handleClear(Bukkit.getPlayer((String)event.getMessage().substring(7)));
        }
    }

    @EventHandler
    public void onCommand(ServerCommandEvent event) {
        if (event.getCommand().startsWith("clear ")) {
            this.handleClear(Bukkit.getPlayer((String)event.getCommand().substring(6)));
        }
    }

    private void handleClear(Player player) {
        if (player != null) {
            Fabled.schedule(() -> {
                PlayerData data = Fabled.getData((OfflinePlayer)player);
                data.getEquips().update(player);
                CLEAR_HANDLERS.forEach(handler -> handler.accept(player));
            }, 1);
        }
    }
}

