/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.metadata.Metadatable;
import studio.magemonkey.codex.util.reflection.ReflectionManager;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ExpSource;
import studio.magemonkey.fabled.api.event.PhysicalDamageEvent;
import studio.magemonkey.fabled.api.event.SkillDamageEvent;
import studio.magemonkey.fabled.api.event.TrueDamageEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.util.BuffManager;
import studio.magemonkey.fabled.api.util.FlagManager;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.ListenerUtil;

public class KillListener
extends FabledListener {
    private static final String S_TYPE = "sType";
    private static final int SPAWNER = 0;
    private static final int EGG = 1;

    public void giveExp(LivingEntity entity, Player killer, int exp) {
        if (!Fabled.getSettings().isWorldEnabled(entity.getWorld())) {
            return;
        }
        if (entity.hasMetadata(S_TYPE)) {
            int value = Fabled.getMetaInt((Metadatable)entity, S_TYPE);
            if (value == 0 && Fabled.getSettings().isBlockSpawner()) {
                return;
            }
            if (value == 1 && Fabled.getSettings().isBlockEgg()) {
                return;
            }
        }
        if (entity.hasMetadata("sapiSumDamage")) {
            return;
        }
        if (killer != null && killer.hasPermission("fabled.exp")) {
            if (killer.getGameMode() == GameMode.CREATIVE && Fabled.getSettings().isBlockCreative()) {
                return;
            }
            PlayerData player = Fabled.getData((OfflinePlayer)killer);
            if (Fabled.getSettings().isUseOrbs()) {
                player.giveExp(exp, ExpSource.MOB);
            } else {
                String name = ListenerUtil.getName((Entity)entity);
                double yield = Fabled.getSettings().getYield(name);
                player.giveExp(yield, ExpSource.MOB);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onKill(EntityDeathEvent event) {
        FlagManager.clearFlags(event.getEntity());
        BuffManager.clearData(event.getEntity());
        this.giveExp(event.getEntity(), event.getEntity().getKiller(), event.getDroppedExp());
    }

    @EventHandler
    public void onSpawn(CreatureSpawnEvent event) {
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            Fabled.setMeta((Metadatable)event.getEntity(), S_TYPE, 0);
        } else if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
            Fabled.setMeta((Metadatable)event.getEntity(), S_TYPE, 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPhysical(PhysicalDamageEvent event) {
        if (event.getDamager() instanceof Player) {
            ReflectionManager.getReflectionUtil().setKiller(event.getTarget(), (Player)event.getDamager());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpell(SkillDamageEvent event) {
        if (event.getDamager() instanceof Player) {
            ReflectionManager.getReflectionUtil().setKiller(event.getTarget(), (Player)event.getDamager());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTrue(TrueDamageEvent event) {
        if (event.getDamager() instanceof Player) {
            ReflectionManager.getReflectionUtil().setKiller(event.getTarget(), (Player)event.getDamager());
        }
    }
}

