/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.event.KeyPressEvent;
import studio.magemonkey.fabled.api.event.PlayerComboStepEvent;
import studio.magemonkey.fabled.api.player.PlayerCombos;
import studio.magemonkey.fabled.data.Click;
import studio.magemonkey.fabled.data.TitleType;
import studio.magemonkey.fabled.language.RPGFilter;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.manager.TitleManager;

public class ComboListener
extends FabledListener {
    private HashMap<UUID, Long> lastClick = new HashMap();
    private HashSet<UUID> onGround = new HashSet();

    @Override
    public void cleanup() {
        this.lastClick.clear();
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.lastClick.remove(event.getPlayer().getUniqueId());
        this.onGround.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onClick(KeyPressEvent event) {
        Long time = this.lastClick.get(event.getPlayer().getUniqueId());
        if (time != null && time > System.currentTimeMillis()) {
            return;
        }
        PlayerCombos combo = Fabled.getData((OfflinePlayer)event.getPlayer()).getComboData();
        switch (event.getKey()) {
            case Q: {
                combo.applyClick(Click.Q);
                break;
            }
            case LEFT: {
                if (event.getPlayer().isSneaking() && Fabled.getComboManager().isClickEnabled(Click.LEFT_SHIFT.getId())) {
                    combo.applyClick(Click.LEFT_SHIFT);
                    break;
                }
                combo.applyClick(Click.LEFT);
                break;
            }
            case RIGHT: {
                if (event.getPlayer().isSneaking() && Fabled.getComboManager().isClickEnabled(Click.RIGHT_SHIFT.getId())) {
                    combo.applyClick(Click.RIGHT_SHIFT);
                    break;
                }
                combo.applyClick(Click.RIGHT);
                break;
            }
            default: {
                return;
            }
        }
        this.lastClick.put(event.getPlayer().getUniqueId(), System.currentTimeMillis() + 40L);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (Fabled.getComboManager().isClickEnabled(Click.Q.getId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onShiftClick(PlayerToggleSneakEvent event) {
        if (event.isSneaking()) {
            Fabled.getData((OfflinePlayer)event.getPlayer()).getComboData().applyClick(Click.SHIFT);
        }
    }

    @EventHandler
    public void onJump(PlayerMoveEvent event) {
        if (event.getTo().getY() > event.getFrom().getY() && event.getPlayer().getNoDamageTicks() == 0 && this.onGround.contains(event.getPlayer().getUniqueId())) {
            Fabled.getData((OfflinePlayer)event.getPlayer()).getComboData().applyClick(Click.SPACE);
        }
        if (event.getPlayer().isOnGround()) {
            this.onGround.add(event.getPlayer().getUniqueId());
        } else {
            this.onGround.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFClick(PlayerSwapHandItemsEvent event) {
        Fabled.getData((OfflinePlayer)event.getPlayer()).getComboData().applyClick(Click.F);
        if (Fabled.getComboManager().isClickEnabled(Click.F.getId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onComboStep(PlayerComboStepEvent event) {
        if (Fabled.getSettings().useTitle(TitleType.COMBO)) {
            PlayerCombos playerCombos = event.getPlayerCombos();
            TitleManager.show(playerCombos.getPlayerData().getPlayer(), TitleType.COMBO, "Combo.gui-display", RPGFilter.COMBO.setReplacement(playerCombos.getCurrentComboString()));
        }
    }
}

