/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.event.KeyPressEvent;
import studio.magemonkey.fabled.listener.FabledListener;

public class ClickListener
extends FabledListener {
    private Set<UUID> dropPlayers = new HashSet<UUID>();

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (this.dropPlayers.contains(event.getPlayer().getUniqueId())) {
            this.dropPlayers.remove(event.getPlayer().getUniqueId());
            return;
        }
        if (!(Fabled.getSettings().isAnimationLeftClick() || event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK)) {
            Bukkit.getServer().getPluginManager().callEvent((Event)new KeyPressEvent(event.getPlayer(), KeyPressEvent.Key.LEFT));
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) {
            Bukkit.getServer().getPluginManager().callEvent((Event)new KeyPressEvent(event.getPlayer(), KeyPressEvent.Key.RIGHT));
        }
    }

    @EventHandler
    public void onEntityClick(PlayerInteractEntityEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (Fabled.getSettings().isInteractRightClick()) {
            KeyPressEvent keyEvent = new KeyPressEvent(event.getPlayer(), KeyPressEvent.Key.RIGHT);
            Bukkit.getServer().getPluginManager().callEvent((Event)keyEvent);
        }
    }

    @EventHandler
    public void animation(PlayerAnimationEvent event) {
        if (!Fabled.getSettings().isAnimationLeftClick()) {
            return;
        }
        KeyPressEvent keyEvent = new KeyPressEvent(event.getPlayer(), KeyPressEvent.Key.LEFT);
        Bukkit.getServer().getPluginManager().callEvent((Event)keyEvent);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        Bukkit.getServer().getPluginManager().callEvent((Event)new KeyPressEvent(event.getPlayer(), KeyPressEvent.Key.Q));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void dropTimer(PlayerDropItemEvent event) {
        this.dropPlayers.add(event.getPlayer().getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)Fabled.getPlugin(Fabled.class), () -> this.dropPlayers.remove(event.getPlayer().getUniqueId()), 2L);
    }
}

