/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.HashMap;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.event.PlayerClassChangeEvent;
import studio.magemonkey.fabled.api.event.PlayerSkillUnlockEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.cast.CastMode;
import studio.magemonkey.fabled.cast.PlayerTextCastingData;
import studio.magemonkey.fabled.gui.handlers.SkillHandler;
import studio.magemonkey.fabled.gui.tool.GUITool;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.MainListener;

public class CastTextListener
extends FabledListener {
    private final CastMode castMode;
    private final HashMap<UUID, ItemStack[]> backup = new HashMap();
    private boolean enabled = true;

    public CastTextListener(CastMode castMode) {
        switch (castMode) {
            case ACTION_BAR: 
            case TITLE: 
            case SUBTITLE: 
            case CHAT: {
                break;
            }
            default: {
                throw new IllegalArgumentException(castMode.name());
            }
        }
        this.castMode = castMode;
    }

    @Override
    public void init() {
        MainListener.registerJoin(this::init);
        Bukkit.getOnlinePlayers().forEach(this::init);
    }

    @Override
    public void cleanup() {
        Bukkit.getOnlinePlayers().stream().filter(player -> Fabled.getSettings().isWorldEnabled(player.getWorld())).forEach(this::init);
        this.enabled = false;
    }

    private void init(Player player) {
        if (player.getOpenInventory().getTopInventory() != null && player.getOpenInventory().getTopInventory().getHolder() instanceof SkillHandler) {
            player.closeInventory();
        }
        Fabled.getData((OfflinePlayer)player).getTextCastingData().validate();
    }

    public void restore(Player player) {
        ItemStack[] backup = this.backup.remove(player.getUniqueId());
        if (backup == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        for (int i = 0; i < backup.length; ++i) {
            inventory.setItem(i, backup[i]);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (!this.isWorldEnabled(player)) {
            return;
        }
        if (event.getInventory().getHolder() instanceof SkillHandler) {
            PlayerInventory inventory = player.getInventory();
            ItemStack[] items = new ItemStack[9];
            for (int i = 0; i < items.length; ++i) {
                ItemStack item = inventory.getItem(i);
                if (item == null || item.getType() == Material.AIR) continue;
                items[i] = item;
            }
            this.backup.put(player.getUniqueId(), items);
            this.refresh(player);
        }
    }

    private void refresh(Player player) {
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        PlayerTextCastingData layout = playerData.getTextCastingData();
        PlayerInventory inventory = player.getInventory();
        ItemStack unassigned = GUITool.markCastItem(Fabled.getSettings().getUnassigned());
        for (int i = 0; i < 9; ++i) {
            if (i == Fabled.getSettings().getCastSlot()) {
                inventory.setItem(i, null);
                continue;
            }
            PlayerSkill skill = playerData.getSkill(layout.getSkill(i));
            inventory.setItem(i, skill == null ? unassigned : GUITool.markCastItem(skill.getData().getIndicator(skill, true)));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.isWorldEnabled(player)) {
            return;
        }
        InventoryView view = event.getView();
        Inventory topInventory = view.getTopInventory();
        Inventory clickedInventory = event.getClickedInventory();
        if (topInventory.getHolder() instanceof SkillHandler) {
            if (clickedInventory == topInventory && event.getClick() == ClickType.NUMBER_KEY) {
                Skill skill = (Skill)((SkillHandler)topInventory.getHolder()).get(event.getSlot());
                if (skill != null) {
                    Fabled.getData((OfflinePlayer)player).getTextCastingData().assign(skill.getName(), event.getHotbarButton());
                    this.refresh(player);
                }
            } else if (clickedInventory == view.getBottomInventory() && event.getSlotType() == InventoryType.SlotType.QUICKBAR) {
                Fabled.getData((OfflinePlayer)player).getTextCastingData().assign(null, event.getSlot());
                this.refresh(player);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (!this.isWorldEnabled(player)) {
            return;
        }
        if (event.getInventory().getHolder() instanceof SkillHandler) {
            this.restore(player);
        }
    }

    private boolean isWorldEnabled(Player player) {
        return Fabled.getSettings().isWorldEnabled(player.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        if (Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            this.init(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChangeWorldPre(PlayerChangedWorldEvent event) {
        if (!Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld()) && Fabled.getSettings().isWorldEnabled(event.getFrom())) {
            this.init(event.getPlayer());
        }
    }

    @EventHandler
    public void onClassChange(PlayerClassChangeEvent event) {
        event.getPlayerData().getTextCastingData().validate();
    }

    @EventHandler
    public void onUnlock(PlayerSkillUnlockEvent event) {
        event.getPlayerData().getTextCastingData().onUnlock(event.getUnlockedSkill().getData().getName());
    }

    @EventHandler
    public void onHandSwap(PlayerSwapHandItemsEvent event) {
        event.setCancelled(true);
        Player player = event.getPlayer();
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        PlayerTextCastingData castData = playerData.getTextCastingData();
        if (castData.isCasting()) {
            castData.setCasting(false);
        } else if (!castData.isEmpty()) {
            castData.setCasting(true);
            switch (this.castMode) {
                case ACTION_BAR: 
                case TITLE: 
                case SUBTITLE: {
                    new CastTextTask(playerData).runTaskTimer((Plugin)Fabled.inst(), 0L, 1L);
                    break;
                }
                case CHAT: {
                    player.sendMessage(castData.getMessage());
                }
            }
        }
    }

    @EventHandler
    public void onHeld(PlayerItemHeldEvent event) {
        PlayerTextCastingData castData = Fabled.getData((OfflinePlayer)event.getPlayer()).getTextCastingData();
        if (!castData.isCasting()) {
            return;
        }
        event.setCancelled(true);
        castData.cast(event.getNewSlot());
    }

    public class CastTextTask
    extends BukkitRunnable {
        private final PlayerData playerData;

        public CastTextTask(PlayerData playerData) {
            this.playerData = playerData;
        }

        public void run() {
            Player player = this.playerData.getPlayer();
            if (!(CastTextListener.this.enabled && player != null && player.isOnline() && CastTextListener.this.isWorldEnabled(player) && this.playerData.getTextCastingData().isCasting())) {
                this.cancel();
                return;
            }
            String message = this.playerData.getTextCastingData().getMessage();
            switch (CastTextListener.this.castMode) {
                case ACTION_BAR: {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
                    break;
                }
                case TITLE: {
                    player.sendTitle(message, "", 0, 20, 0);
                    break;
                }
                case SUBTITLE: {
                    player.sendTitle(" ", message, 0, 20, 0);
                }
            }
        }

        public synchronized void cancel() throws IllegalStateException {
            Player player;
            super.cancel();
            if (CastTextListener.this.castMode == CastMode.ACTION_BAR && (player = this.playerData.getPlayer()) != null) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
            }
        }
    }
}

