/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.event.PlayerClassChangeEvent;
import studio.magemonkey.fabled.api.event.PlayerSkillUnlockEvent;
import studio.magemonkey.fabled.cast.PlayerCastBars;
import studio.magemonkey.fabled.gui.tool.GUITool;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.MainListener;

public class CastBarsListener
extends FabledListener {
    private final Set<UUID> playersDropping = new HashSet<UUID>();

    private static void cleanup(Player player) {
        if (Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            CastBarsListener.forceCleanup(player);
        }
    }

    private static void forceCleanup(Player player) {
        Fabled.getData((OfflinePlayer)player).getCastBars().restore();
        GUITool.removeCastItems(player);
    }

    @Override
    public void init() {
        MainListener.registerJoin(this::init);
        MainListener.registerClear(this::handleClear);
        Bukkit.getOnlinePlayers().forEach(this::init);
    }

    @Override
    public void cleanup() {
        Bukkit.getOnlinePlayers().forEach(CastBarsListener::cleanup);
    }

    @EventHandler
    public void onDamaged(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            Fabled.getData((OfflinePlayer)player).getCastBars().restore();
        }
    }

    @EventHandler
    public void onClassChange(PlayerClassChangeEvent event) {
        event.getPlayerData().getCastBars().reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChangedWorldPre(PlayerChangedWorldEvent event) {
        boolean from = Fabled.getSettings().isWorldEnabled(event.getFrom());
        boolean to = Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if (from && !to) {
            CastBarsListener.forceCleanup(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        boolean from = Fabled.getSettings().isWorldEnabled(event.getFrom());
        boolean to = Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if (to && !from) {
            this.init(event.getPlayer());
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        if (Fabled.getSettings().isWorldEnabled(event.getEntity().getWorld())) {
            event.getDrops().remove(event.getEntity().getInventory().getItem(Fabled.getSettings().getCastSlot()));
        }
    }

    private void init(Player player) {
        GUITool.removeCastItems(player);
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        int slot = Fabled.getSettings().getCastSlot();
        ItemStack item = inv.getItem(slot);
        inv.setItem(slot, Fabled.getSettings().getCastItem());
        if (item != null && item.getType() != Material.AIR) {
            inv.addItem(new ItemStack[]{item});
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        CastBarsListener.cleanup(event.getPlayer());
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        Fabled.getData((OfflinePlayer)((Player)event.getPlayer())).getCastBars().handleOpen();
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        Fabled.getData((OfflinePlayer)((Player)event.getPlayer())).getCastBars().restore();
        this.init((Player)event.getPlayer());
    }

    @EventHandler
    public void onUnlock(PlayerSkillUnlockEvent event) {
        if (event.getUnlockedSkill().getData().canCast() && event.getPlayerData().getPlayer() != null) {
            event.getPlayerData().getCastBars().unlock(event.getUnlockedSkill());
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (Fabled.getSettings().isWorldEnabled(event.getWhoClicked().getWorld())) {
            int slot = Fabled.getSettings().getCastSlot();
            if (event.getView().getTopInventory().getHolder() instanceof PlayerCastBars && event.getClickedInventory() instanceof PlayerInventory && event.getSlot() == slot + 27 || event.getSlot() == slot && event.getSlotType() == InventoryType.SlotType.QUICKBAR || (event.getAction() == InventoryAction.HOTBAR_SWAP || event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) && event.getHotbarButton() == slot) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        if (Fabled.getData((OfflinePlayer)player).getCastBars().handleInteract(player)) {
            event.getItemDrop().remove();
            this.dropped(player.getUniqueId());
        } else if (player.getInventory().getHeldItemSlot() == Fabled.getSettings().getCastSlot()) {
            event.getItemDrop().remove();
            this.dropped(player.getUniqueId());
            Fabled.getData((OfflinePlayer)player).getCastBars().showOrganizer(player);
        }
    }

    private void dropped(final UUID uuid) {
        this.playersDropping.add(uuid);
        new BukkitRunnable(){

            public void run() {
                CastBarsListener.this.playersDropping.remove(uuid);
            }
        }.runTask((Plugin)Fabled.inst());
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (!Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            return;
        }
        PlayerCastBars bars = Fabled.getData((OfflinePlayer)event.getPlayer()).getCastBars();
        if (bars.isHovering()) {
            event.setCancelled(true);
        }
        if (event.getPlayer().getInventory().getHeldItemSlot() == Fabled.getSettings().getCastSlot()) {
            event.setCancelled(true);
            if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (this.playersDropping.remove(event.getPlayer().getUniqueId())) {
                    return;
                }
                Fabled.getData((OfflinePlayer)event.getPlayer()).getCastBars().restore();
                bars.showHoverBar(event.getPlayer());
            } else if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                bars.showInstantBar(event.getPlayer());
            }
        }
    }

    @EventHandler
    public void onHeld(PlayerItemHeldEvent event) {
        Fabled.getData((OfflinePlayer)event.getPlayer()).getCastBars().handle(event);
    }

    private void handleClear(Player player) {
        player.getInventory().setItem(Fabled.getSettings().getCastSlot(), Fabled.getSettings().getCastItem());
        Fabled.getData((OfflinePlayer)player).setOnPreviewStop(null);
    }
}

