/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.hook;

import java.util.Locale;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.ModdedDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.ArmorStandWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.log.Logger;

public class DisguiseHook {
    public static void disguiseMob(LivingEntity target, String type, boolean adult) {
        try {
            String name = target.getCustomName();
            DisguiseType disguise = DisguiseType.valueOf((String)type.toUpperCase(Locale.US).replace(" ", "_"));
            MobDisguise mobDisguise = new MobDisguise(disguise, adult);
            DisguiseAPI.disguiseToAll((Entity)target, (Disguise)mobDisguise);
            if (name != null) {
                target.setCustomName(name);
            }
        }
        catch (Exception ex) {
            Logger.invalid("Invalid mob disguise type: " + type);
        }
    }

    public static void disguisePlayer(LivingEntity target, String player) {
        try {
            String name = target.getCustomName();
            PlayerDisguise playerDisguise = new PlayerDisguise(player);
            DisguiseAPI.disguiseToAll((Entity)target, (Disguise)playerDisguise);
            if (name != null) {
                target.setCustomName(name);
            }
        }
        catch (Exception ex) {
            Logger.invalid("Invalid player disguise: " + player);
        }
    }

    public static void disguiseMisc(LivingEntity target, String type, int data) {
        try {
            String name = target.getCustomName();
            DisguiseType disguise = DisguiseType.valueOf((String)type.toUpperCase(Locale.US).replace(" ", "_"));
            MiscDisguise miscDisguise = new MiscDisguise(disguise, data);
            DisguiseAPI.disguiseToAll((Entity)target, (Disguise)miscDisguise);
            if (name != null) {
                target.setCustomName(name);
            }
        }
        catch (Exception ex) {
            Logger.invalid("Invalid misc disguise type: " + type);
        }
    }

    public static void disguiseMisc(LivingEntity target, String type, Material mat) {
        try {
            String name = target.getCustomName();
            DisguiseType disguise = DisguiseType.valueOf((String)type.toUpperCase(Locale.US).replace(" ", "_"));
            MiscDisguise miscDisguise = new MiscDisguise(disguise, mat);
            DisguiseAPI.disguiseToAll((Entity)target, (Disguise)miscDisguise);
            if (name != null) {
                target.setCustomName(name);
            }
        }
        catch (Exception ex) {
            Logger.invalid("Invalid misc disguise type: " + type);
        }
    }

    public static void removeDisguise(LivingEntity target) {
        for (Disguise disguise : DisguiseAPI.getDisguises((Entity)target)) {
            disguise.removeDisguise();
        }
    }

    public static FakeBoundingBox getFakeBoundingBox(Entity entity) {
        Disguise disguise = DisguiseAPI.getDisguise((Entity)entity);
        if (disguise instanceof MiscDisguise) {
            DisguiseValues values = DisguiseValues.getDisguiseValues((DisguiseType)disguise.getType());
            if (values == null) {
                return null;
            }
            return values.getAdultBox();
        }
        if (disguise instanceof MobDisguise) {
            MobDisguise mobDisguise = (MobDisguise)disguise;
            DisguiseValues values = DisguiseValues.getDisguiseValues((DisguiseType)mobDisguise.getType());
            if (values != null && values.getAdultBox() != null) {
                if (!mobDisguise.isAdult() && values.getBabyBox() != null) {
                    return values.getBabyBox();
                }
                if (mobDisguise.getWatcher() != null) {
                    if (mobDisguise.getType() == DisguiseType.ARMOR_STAND) {
                        return ((ArmorStandWatcher)mobDisguise.getWatcher()).isSmall() ? values.getBabyBox() : values.getAdultBox();
                    }
                    if (mobDisguise.getType() == DisguiseType.SLIME || mobDisguise.getType() == DisguiseType.MAGMA_CUBE) {
                        double a = 0.13005 * (double)((SlimeWatcher)mobDisguise.getWatcher()).getSize();
                        return new FakeBoundingBox(a, a, a);
                    }
                }
                return values.getAdultBox();
            }
            return null;
        }
        if (disguise instanceof ModdedDisguise) {
            return null;
        }
        if (disguise instanceof PlayerDisguise) {
            if (disguise.getWatcher() == null) {
                return new FakeBoundingBox(0.6, 0.6, 1.8);
            }
            if (disguise.getEntity() != null && !disguise.getWatcher().getModifiedEntityAnimations()[1]) {
                return disguise.getEntity() instanceof Player && ((Player)disguise.getEntity()).isSneaking() ? new FakeBoundingBox(0.6, 0.6, 1.5) : new FakeBoundingBox(0.6, 0.6, 1.8);
            }
            return disguise.getWatcher().isSneaking() ? new FakeBoundingBox(0.6, 0.6, 1.5) : new FakeBoundingBox(0.6, 0.6, 1.8);
        }
        return null;
    }
}

