/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.gui.tool;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.gui.tool.GUIHolder;
import studio.magemonkey.fabled.gui.tool.GUIPage;
import studio.magemonkey.fabled.gui.tool.GUITool;
import studio.magemonkey.fabled.gui.tool.IconHolder;
import studio.magemonkey.fabled.tree.basic.CustomTree;
import studio.magemonkey.fabled.tree.basic.InventoryTree;

public class GUIData {
    public static final String ROWS = "rows";
    public static final String PAGES = "pages";
    public static final String SLOTS = "slots";
    private final ArrayList<GUIPage> pageMap = new ArrayList();
    private boolean editable = true;
    private int rows = 3;
    private int pages = 1;
    private int nav = 0;

    GUIData() {
        this.pageMap.add(new GUIPage(this));
    }

    GUIData(InventoryTree skillTree) {
        int slotsPerPage;
        if (!(skillTree instanceof CustomTree)) {
            this.editable = false;
        }
        this.rows = skillTree.getHeight();
        try {
            Preconditions.checkArgument((this.rows > 0 && this.rows <= 6 ? 1 : 0) != 0);
        }
        catch (IllegalArgumentException e) {
            Fabled.inst().getLogger().warning("Error loading GUI: Rows should be > 0 and <= 6. Rows: " + this.rows);
            throw e;
        }
        TreeMap<Integer, Skill> skillSlots = skillTree.getSkillSlots();
        int i = slotsPerPage = this.rows * 9;
        HashMap<Integer, Skill> map = new HashMap<Integer, Skill>();
        for (Map.Entry<Integer, Skill> entry : skillSlots.entrySet()) {
            int slot = entry.getKey();
            if (slot >= i) {
                this.pageMap.add(new GUIPage(this, map));
                map.clear();
                i += slotsPerPage;
            }
            map.put(slot - i + slotsPerPage, entry.getValue());
        }
        if (!map.isEmpty() || this.pageMap.isEmpty()) {
            this.pageMap.add(new GUIPage(this, map));
        }
        this.pages = this.pageMap.size();
    }

    GUIData(DataSection data) {
        if (data != null) {
            this.rows = data.getInt(ROWS, this.rows);
            try {
                Preconditions.checkArgument((this.rows > 0 && this.rows <= 6 ? 1 : 0) != 0);
            }
            catch (IllegalArgumentException e) {
                Fabled.inst().getLogger().warning("Error loading GUI: Rows should be > 0 and <= 6. Rows: " + this.rows);
                throw e;
            }
            this.pages = data.getInt(PAGES, this.pages);
            DataSection pages = data.getSection(SLOTS);
            if (pages != null) {
                for (String page : pages.keys()) {
                    if (!pages.isSection(page)) continue;
                    this.pageMap.add(new GUIPage(this, pages.getSection(page)));
                }
            }
        }
        while (this.pageMap.size() < this.pages) {
            this.pageMap.add(new GUIPage(this));
        }
    }

    public void show(GUIHolder handler, PlayerData player, String title, Map<String, ? extends IconHolder> data) {
        Inventory inv = Bukkit.getServer().createInventory((InventoryHolder)handler, this.rows * 9, title);
        ItemStack[] contents = this.pageMap.get(0).instance(player, data);
        if (this.pages > 1) {
            GUITool.addPageButtons(contents);
        }
        inv.setContents(contents);
        handler.set(this, player, inv, data);
        player.getPlayer().openInventory(inv);
    }

    public GUIPage getPage(int page) {
        return this.pageMap.get(page % this.pages);
    }

    public GUIPage getPage() {
        return this.pageMap.get(this.nav);
    }

    public int getSize() {
        return this.rows * 9;
    }

    public void init(ItemStack[] contents) {
        this.nav = 0;
        this.fill(contents);
    }

    public void load(ItemStack[] contents) {
        this.pageMap.get(this.nav).load(contents);
    }

    public void fill(ItemStack[] contents) {
        this.pageMap.get(this.nav).fill(contents);
    }

    public void next() {
        this.nav = (this.nav + 1) % this.pages;
    }

    public void prev() {
        this.nav = (this.nav + this.pages - 1) % this.pages;
    }

    public void addPage() {
        this.pageMap.add(new GUIPage(this));
        ++this.pages;
        ++this.nav;
        if (this.pages == 2) {
            for (GUIPage page : this.pageMap) {
                page.clearRight();
            }
        }
    }

    public void removePage() {
        this.pageMap.remove(this.nav);
        --this.pages;
        this.nav = Math.min(this.nav, this.pages - 1);
        if (this.pages == 0) {
            this.addPage();
        }
    }

    public void resize(int rows) {
        this.rows = Math.max(Math.min(rows, 6), 1);
    }

    public void shrink() {
        if (this.rows > 1) {
            --this.rows;
        }
        for (GUIPage page : this.pageMap) {
            page.remove(this.getSize(), this.getSize() + 9);
        }
    }

    public void grow() {
        if (this.rows < 6) {
            ++this.rows;
        }
    }

    public boolean isValid() {
        for (GUIPage page : this.pageMap) {
            if (!page.isValid()) continue;
            return true;
        }
        return false;
    }

    public boolean has(String item) {
        for (GUIPage page : this.pageMap) {
            if (page.getIndex(item) == -1) continue;
            return true;
        }
        return false;
    }

    public void save(DataSection data) {
        data.set(ROWS, (Object)this.rows);
        data.set(PAGES, (Object)this.pages);
        DataSection slots = data.createSection(SLOTS);
        int i = 0;
        for (GUIPage page : this.pageMap) {
            page.save(slots.createSection("" + ++i));
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public int getPages() {
        return this.pages;
    }
}

