/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.List;
import java.util.Objects;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.event.SignalEmitEvent;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class SignalTrigger
implements Trigger<SignalEmitEvent> {
    @Override
    public String getKey() {
        return "signal";
    }

    @Override
    public Class<SignalEmitEvent> getEvent() {
        return SignalEmitEvent.class;
    }

    @Override
    public boolean shouldTrigger(SignalEmitEvent event, int level, Settings settings) {
        return Objects.equals(settings.getString("signal"), event.getSignal());
    }

    @Override
    public void setValues(SignalEmitEvent event, CastData data) {
        List<Object> arguments = event.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            Object arg = arguments.get(i);
            if (i == 0) {
                data.put("api-arg", arg);
            }
            data.put(String.format("api-arg[%d]", i), arg);
        }
    }

    @Override
    public LivingEntity getCaster(SignalEmitEvent event) {
        return event.isSelfHandling() ? event.getEmitter() : event.getReceiver();
    }

    @Override
    public LivingEntity getTarget(SignalEmitEvent event, Settings settings) {
        return settings.getBool("target", false) ? event.getReceiver() : event.getEmitter();
    }
}

