/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.target;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.GameMode;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.Metadatable;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.target.TargetHelper;
import studio.magemonkey.fabled.dynamic.ComponentType;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.EffectComponent;
import studio.magemonkey.fabled.dynamic.TempEntity;

public abstract class TargetComponent
extends EffectComponent {
    private static final String ALLY = "group";
    private static final String WALL = "wall";
    private static final String CASTER = "caster";
    protected static final String MAX = "max";
    private static final String INVULNERABLE = "invulnerable";
    boolean everyone;
    boolean allies;
    boolean throughWall;
    boolean invulnerable;
    IncludeCaster self;

    @Override
    public ComponentType getType() {
        return ComponentType.TARGET;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        List<LivingEntity> list = this.getTargets(caster, level, targets);
        DynamicSkill.getCastData(caster).put("api-num-targets", list.size());
        return !list.isEmpty() && this.executeChildren(caster, level, list, force);
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        String group = this.settings.getString(ALLY, "enemy").toLowerCase();
        this.everyone = group.equals("both");
        this.allies = group.equals("ally");
        this.throughWall = this.settings.getString(WALL, "false").equalsIgnoreCase("true");
        this.invulnerable = this.settings.getString(INVULNERABLE, "false").equalsIgnoreCase("true");
        this.self = IncludeCaster.valueOf(this.settings.getString(CASTER, "false").toUpperCase(Locale.US).replace(' ', '_'));
    }

    abstract List<LivingEntity> getTargets(LivingEntity var1, int var2, List<LivingEntity> var3);

    @Override
    public void playPreview(List<Runnable> onPreviewStop, Player caster, int level, Supplier<List<LivingEntity>> targetSupplier) {
        Supplier<List<LivingEntity>> supplier = () -> this.getTargets((LivingEntity)caster, level, (List)targetSupplier.get());
        super.playPreview(onPreviewStop, caster, level, supplier);
        this.playChildrenPreviews(onPreviewStop, caster, level, supplier);
    }

    List<LivingEntity> determineTargets(LivingEntity caster, int level, List<LivingEntity> from, Function<LivingEntity, List<LivingEntity>> conversion) {
        double max = this.parseValues(caster, MAX, level, 99.0);
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        from.forEach(target -> {
            List found = (List)conversion.apply((LivingEntity)target);
            int count = 0;
            for (LivingEntity entity : found) {
                if ((double)count >= max) break;
                if (!this.isValidTarget(caster, (LivingEntity)target, entity) && (!this.self.equals((Object)IncludeCaster.IN_AREA) || caster != entity)) continue;
                list.add(entity);
                ++count;
            }
        });
        if (this.self.equals((Object)IncludeCaster.TRUE)) {
            list.add(caster);
        }
        return list;
    }

    boolean isValidTarget(LivingEntity caster, LivingEntity from, LivingEntity target) {
        if (Fabled.getMeta((Metadatable)target, "asMechanic") != null) {
            return false;
        }
        if (target instanceof TempEntity) {
            return true;
        }
        if (target.isInvulnerable() && !this.invulnerable) {
            return false;
        }
        if (target instanceof Player && (((Player)target).getGameMode() == GameMode.SPECTATOR || ((Player)target).getGameMode() == GameMode.CREATIVE)) {
            return false;
        }
        return !(target == caster || !Fabled.getSettings().isValidTarget(target) || !this.throughWall && TargetHelper.isObstructed(from.getEyeLocation(), target.getEyeLocation()) || !this.everyone && this.allies != Fabled.getSettings().isAlly(caster, target));
    }

    public static enum IncludeCaster {
        TRUE,
        FALSE,
        IN_AREA;

    }
}

