/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.value;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ValueAddMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String AMOUNT = "amount";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value add";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty() || !this.settings.has(KEY)) {
            return false;
        }
        String key = this.settings.getString(KEY);
        double amount = this.parseValues(caster, AMOUNT, level, 1.0) * (double)targets.size();
        CastData data = DynamicSkill.getCastData(caster);
        if (!data.contains(key)) {
            data.put(key, amount);
        } else {
            data.put(key, amount + data.getDouble(key));
        }
        if (this.settings.getBool(SAVE, false)) {
            Fabled.getData((OfflinePlayer)caster).setPersistentData(key, data.getRaw(key));
        }
        return true;
    }
}

