/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.armorstand;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.Metadatable;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.armorstand.ArmorStandInstance;
import studio.magemonkey.fabled.api.armorstand.ArmorStandManager;
import studio.magemonkey.fabled.dynamic.TempEntity;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.task.RemoveTask;
import studio.magemonkey.fabled.util.ThrowableSupplier;

public class ArmorStandMechanic
extends MechanicComponent {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String KEY = "key";
    private static final String DURATION = "duration";
    private static final String NAME = "name";
    private static final String NAME_VISIBLE = "name-visible";
    private static final String FOLLOW = "follow";
    private static final String GRAVITY = "gravity";
    private static final String SMALL = "tiny";
    private static final String ARMS = "arms";
    private static final String BASE = "base";
    private static final String VISIBLE = "visible";
    private static final String MARKER = "marker";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";

    @Override
    public String getKey() {
        return "armor stand";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String key = this.settings.getString(KEY, this.skill.getName());
        int duration = (int)(20.0 * this.parseValues(caster, DURATION, level, 5.0));
        String name = this.settings.getString(NAME, "Armor Stand");
        boolean nameVisible = this.settings.getBool(NAME_VISIBLE, false);
        boolean follow = this.settings.getBool(FOLLOW, false);
        boolean gravity = this.settings.getBool(GRAVITY, false);
        boolean small = this.settings.getBool(SMALL, false);
        boolean arms = this.settings.getBool(ARMS, false);
        boolean base = this.settings.getBool(BASE, false);
        boolean visible = this.settings.getBool(VISIBLE, true);
        boolean marker = this.settings.getBool(MARKER, false);
        double forward = this.parseValues(caster, FORWARD, level, 0.0);
        double upward = this.parseValues(caster, UPWARD, level, 0.0);
        double right = this.parseValues(caster, RIGHT, level, 0.0);
        ArrayList<LivingEntity> armorStands = new ArrayList<LivingEntity>();
        for (LivingEntity target : targets) {
            Location loc = target.getLocation().clone();
            Vector dir = loc.getDirection().setY(0).normalize();
            Vector side = dir.clone().crossProduct(UP);
            loc.add(dir.multiply(forward)).add(0.0, upward, 0.0).add(side.multiply(right));
            Consumer<ArmorStand> onSpawn = as -> {
                try {
                    as.setPersistent(false);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                try {
                    as.setMarker(marker);
                    as.setInvulnerable(true);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                try {
                    as.setSilent(true);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                as.setGravity(gravity);
                as.setCustomName(name);
                as.setCustomNameVisible(nameVisible);
                as.setSmall(small);
                as.setArms(arms);
                as.setBasePlate(base);
                as.setVisible(visible);
            };
            ArmorStand as2 = (ArmorStand)ThrowableSupplier.tryWithRecovers(() -> (ArmorStand)target.getWorld().spawn(loc, ArmorStand.class, onSpawn), () -> {
                Class<?> regionAccessor = Class.forName("org.bukkit.RegionAccessor");
                Method method = regionAccessor.getDeclaredMethod("spawn", Location.class, Class.class, org.bukkit.util.Consumer.class);
                Object[] objectArray = new Object[3];
                objectArray[0] = loc;
                objectArray[1] = ArmorStand.class;
                objectArray[2] = onSpawn::accept;
                return (ArmorStand)method.invoke((Object)target.getWorld(), objectArray);
            }, () -> {
                ArmorStand stand = (ArmorStand)target.getWorld().spawn(loc, ArmorStand.class);
                onSpawn.accept(stand);
                return stand;
            });
            Fabled.setMeta((Metadatable)as2, "asMechanic", true);
            armorStands.add((LivingEntity)as2);
            ArmorStandInstance instance = follow ? new ArmorStandInstance(as2, target, true, forward, upward, right) : new ArmorStandInstance(as2, target, false);
            ArmorStandManager.register(instance, target, key);
        }
        this.executeChildren(caster, level, armorStands, force);
        new RemoveTask(armorStands, duration);
        return targets.size() > 0;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, Player caster, int level, Supplier<List<LivingEntity>> targetSupplier) {
        double forward = this.parseValues((LivingEntity)caster, FORWARD, level, 0.0);
        double upward = this.parseValues((LivingEntity)caster, UPWARD, level, 0.0);
        double right = this.parseValues((LivingEntity)caster, RIGHT, level, 0.0);
        super.playPreview(onPreviewStop, caster, level, () -> {
            ArrayList<TempEntity> newTargets = new ArrayList<TempEntity>();
            for (LivingEntity target : (List)targetSupplier.get()) {
                Location loc = target.getLocation().clone();
                Vector dir = loc.getDirection().setY(0).normalize();
                Vector side = dir.clone().crossProduct(UP);
                loc.add(dir.multiply(forward)).add(0.0, upward, 0.0).add(side.multiply(right));
                newTargets.add(new TempEntity(loc));
            }
            return newTargets;
        });
    }
}

