/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.metadata.Metadatable;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.skills.PassiveSkill;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.task.RemoveTask;

public class WolfMechanic
extends MechanicComponent {
    public static final String SKILL_META = "sapi_wolf_skills";
    public static final String LEVEL = "sapi_wolf_level";
    private static final String COLOR = "color";
    private static final String HEALTH = "health";
    private static final String SECONDS = "seconds";
    private static final String NAME = "name";
    private static final String DAMAGE = "damage";
    private static final String SKILLS = "skills";
    private static final String AMOUNT = "amount";
    private static final String SITTING = "sitting";
    private final Map<Integer, RemoveTask> tasks = new HashMap<Integer, RemoveTask>();

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!(caster instanceof Player)) {
            return false;
        }
        this.cleanUp(caster);
        Player player = (Player)caster;
        String color = this.settings.getString(COLOR);
        double health = this.parseValues((LivingEntity)player, HEALTH, level, 10.0);
        String name = TextFormatter.colorString((String)this.filter(caster, null, this.settings.getString(NAME, "").replace("{player}", player.getName())));
        double damage = this.parseValues((LivingEntity)player, DAMAGE, level, 3.0);
        double amount = this.parseValues((LivingEntity)player, AMOUNT, level, 1.0);
        boolean sitting = this.settings.getString(SITTING, "false").equalsIgnoreCase("true");
        List<String> skills = this.settings.getStringList(SKILLS);
        DyeColor dye = null;
        if (color != null) {
            try {
                dye = DyeColor.valueOf((String)color.toUpperCase(Locale.US));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double seconds = this.parseValues((LivingEntity)player, SECONDS, level, 10.0);
        int ticks = (int)(seconds * 20.0);
        ArrayList<LivingEntity> wolves = new ArrayList<LivingEntity>();
        for (LivingEntity target : targets) {
            int i = 0;
            while ((double)i < amount) {
                Wolf wolf = (Wolf)target.getWorld().spawn(target.getLocation(), Wolf.class);
                wolf.setOwner((AnimalTamer)player);
                wolf.setMaxHealth(health);
                wolf.setHealth(health);
                wolf.setSitting(sitting);
                Fabled.setMeta((Metadatable)wolf, "sapiSumDamage", damage);
                ArrayList<Player> owner = new ArrayList<Player>(1);
                owner.add(player);
                DynamicSkill.getCastData((LivingEntity)wolf).put("api-owner", owner);
                if (dye != null) {
                    wolf.setCollarColor(dye);
                }
                if (name.length() > 0) {
                    wolf.setCustomName(name);
                    wolf.setCustomNameVisible(true);
                }
                for (String skillName : skills) {
                    Skill skill = Fabled.getSkill(skillName);
                    if (!(skill instanceof PassiveSkill)) continue;
                    ((PassiveSkill)((Object)skill)).initialize((LivingEntity)wolf, level);
                }
                Fabled.setMeta((Metadatable)wolf, SKILL_META, skills);
                Fabled.setMeta((Metadatable)wolf, LEVEL, level);
                wolves.add((LivingEntity)wolf);
                ++i;
            }
        }
        RemoveTask task = new RemoveTask(wolves, ticks);
        this.tasks.put(caster.getEntityId(), task);
        if (wolves.size() > 0) {
            this.executeChildren((LivingEntity)player, level, wolves, force);
            return true;
        }
        return false;
    }

    @Override
    public String getKey() {
        return "wolf";
    }

    @Override
    public void cleanUp(LivingEntity caster) {
        RemoveTask task = this.tasks.remove(caster.getEntityId());
        if (task != null) {
            task.cancel();
            task.run();
        }
    }
}

