/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class SummonMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String HEALTH = "health";
    private static final String NAME = "name";
    private static final String AMOUNT = "amount";

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        this.cleanUp(caster);
        Player player = (Player)caster;
        double health = this.parseValues((LivingEntity)player, HEALTH, level, 10.0);
        String type = this.settings.getString(TYPE, "Zombie");
        String name = TextFormatter.colorString((String)this.filter(caster, null, this.settings.getString(NAME, "").replace("{player}", player.getName())));
        double amount = this.parseValues((LivingEntity)player, AMOUNT, level, 1.0);
        EntityType entType = EntityType.valueOf((String)type.replace(" ", "_").toUpperCase(Locale.US));
        ArrayList<LivingEntity> wolves = new ArrayList<LivingEntity>();
        for (LivingEntity target : targets) {
            int i = 0;
            while ((double)i < amount) {
                Entity entity = target.getWorld().spawn(target.getLocation(), entType.getEntityClass());
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).setMaxHealth(health);
                    ((LivingEntity)entity).setHealth(health);
                    ArrayList<Player> owner = new ArrayList<Player>(1);
                    owner.add(player);
                    DynamicSkill.getCastData((LivingEntity)entity).put("api-owner", owner);
                    wolves.add((LivingEntity)entity);
                }
                if (!name.isBlank()) {
                    entity.setCustomName(name);
                    entity.setCustomNameVisible(true);
                }
                ++i;
            }
        }
        if (!wolves.isEmpty()) {
            this.executeChildren((LivingEntity)player, level, wolves, force);
            return true;
        }
        return false;
    }

    @Override
    public String getKey() {
        return "summon";
    }
}

